/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.limit;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.limit.ConcurrencyLimitBuilder;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@FunctionalInterface
@UnstableApi
public interface ConcurrencyLimit {
    public static ConcurrencyLimit of(int maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    @UnstableApi
    public static ConcurrencyLimit of(IntSupplier maxConcurrency) {
        return ConcurrencyLimit.builder(maxConcurrency).build();
    }

    public static ConcurrencyLimitBuilder builder(int maxConcurrency) {
        Preconditions.checkArgument(maxConcurrency >= 0, "maxConcurrency: %s (expected: >= 0)", maxConcurrency);
        return new ConcurrencyLimitBuilder(maxConcurrency == Integer.MAX_VALUE ? 0 : maxConcurrency);
    }

    @UnstableApi
    public static ConcurrencyLimitBuilder builder(IntSupplier maxConcurrency) {
        Objects.requireNonNull(maxConcurrency, "maxConcurrency");
        return new ConcurrencyLimitBuilder(maxConcurrency);
    }

    public CompletableFuture<SafeCloseable> acquire(ClientRequestContext var1);
}

