/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.limit;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.limit.ConcurrencyLimit;
import karate.com.linecorp.armeria.client.limit.DefaultConcurrencyLimit;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@UnstableApi
public final class ConcurrencyLimitBuilder {
    static final CompletableFuture<SafeCloseable> noLimitFuture = UnmodifiableFuture.completedFuture(() -> {});
    private static final ConcurrencyLimit noLimit = ctx -> noLimitFuture;
    static final long DEFAULT_TIMEOUT_MILLIS = 10000L;
    static final int DEFAULT_MAX_PENDING_ACQUIRES = Integer.MAX_VALUE;
    private final boolean useLimit;
    private final IntSupplier maxConcurrency;
    private long timeoutMillis = 10000L;
    private int maxPendingAcquisitions = Integer.MAX_VALUE;
    private Predicate<? super ClientRequestContext> predicate = requestContext -> true;

    ConcurrencyLimitBuilder(int maxConcurrency) {
        this.useLimit = maxConcurrency != 0 && maxConcurrency != Integer.MAX_VALUE;
        this.maxConcurrency = () -> maxConcurrency;
    }

    ConcurrencyLimitBuilder(IntSupplier maxConcurrency) {
        this.useLimit = true;
        this.maxConcurrency = maxConcurrency;
    }

    public ConcurrencyLimitBuilder timeoutMillis(long timeoutMillis) {
        Preconditions.checkArgument(timeoutMillis >= 0L, "timeout: %s (expected: >= 0)", timeoutMillis);
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public ConcurrencyLimitBuilder timeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.timeoutMillis(timeout.toMillis());
        return this;
    }

    public ConcurrencyLimitBuilder maxPendingAcquisitions(int maxPendingAcquisitions) {
        Preconditions.checkArgument(maxPendingAcquisitions >= 0, "maxPendingAcquisitions: %s (expected: >= 0)", maxPendingAcquisitions);
        this.maxPendingAcquisitions = maxPendingAcquisitions;
        return this;
    }

    public ConcurrencyLimitBuilder predicate(Predicate<? super ClientRequestContext> predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        return this;
    }

    public ConcurrencyLimit build() {
        if (!this.useLimit) {
            return noLimit;
        }
        return new DefaultConcurrencyLimit(this.predicate, this.maxConcurrency, this.maxPendingAcquisitions, this.timeoutMillis);
    }
}

