/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.logging;

import java.util.Objects;
import karate.com.linecorp.armeria.client.Client;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.SimpleDecoratingClient;
import karate.com.linecorp.armeria.common.Request;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.logging.LogWriter;
import karate.com.linecorp.armeria.common.logging.RequestLog;
import karate.com.linecorp.armeria.common.util.Sampler;
import karate.com.linecorp.armeria.internal.common.logging.LoggingUtils;

abstract class AbstractLoggingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private final LogWriter logWriter;
    private final Sampler<? super RequestLog> sampler;

    AbstractLoggingClient(Client<I, O> delegate, LogWriter logWriter, Sampler<? super ClientRequestContext> successSampler, Sampler<? super ClientRequestContext> failureSampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.logWriter = Objects.requireNonNull(logWriter, "logWriter");
        Objects.requireNonNull(successSampler, "successSampler");
        Objects.requireNonNull(failureSampler, "failureSampler");
        this.sampler = requestLog -> {
            ClientRequestContext ctx = (ClientRequestContext)requestLog.context();
            if (ctx.options().successFunction().isSuccess(ctx, (RequestLog)requestLog)) {
                return successSampler.isSampled(ctx);
            }
            return failureSampler.isSampled(ctx);
        };
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        ctx.log().whenComplete().thenAccept(log -> {
            if (this.sampler.isSampled((RequestLog)log)) {
                LoggingUtils.log(ctx, log, this.logWriter);
            }
        });
        return ((Client)this.unwrap()).execute(ctx, req);
    }
}

