/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.logging;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.Client;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import karate.com.linecorp.armeria.client.logging.ContentPreviewingClientBuilder;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ContentPreviewer;
import karate.com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.internal.logging.ContentPreviewingUtil;
import karate.io.netty.util.AttributeKey;

public final class ContentPreviewingClient
extends SimpleDecoratingHttpClient {
    private static final AttributeKey<Boolean> SETTING_CONTENT_PREVIEW = AttributeKey.valueOf(ContentPreviewingClient.class, "SETTING_CONTENT_PREVIEW");
    private final ContentPreviewerFactory contentPreviewerFactory;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer;

    public static Function<? super HttpClient, ContentPreviewingClient> newDecorator(int maxLength) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength);
        return ContentPreviewingClient.builder(factory).newDecorator();
    }

    public static Function<? super HttpClient, ContentPreviewingClient> newDecorator(int maxLength, Charset defaultCharset) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength, defaultCharset);
        return ContentPreviewingClient.builder(factory).newDecorator();
    }

    public static Function<? super HttpClient, ContentPreviewingClient> newDecorator(ContentPreviewerFactory contentPreviewerFactory) {
        return ContentPreviewingClient.builder(contentPreviewerFactory).newDecorator();
    }

    public static ContentPreviewingClientBuilder builder(ContentPreviewerFactory contentPreviewerFactory) {
        return new ContentPreviewingClientBuilder(Objects.requireNonNull(contentPreviewerFactory, "contentPreviewerFactory"));
    }

    ContentPreviewingClient(HttpClient delegate, ContentPreviewerFactory contentPreviewerFactory, BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer, BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer) {
        super(delegate);
        this.contentPreviewerFactory = contentPreviewerFactory;
        this.requestPreviewSanitizer = requestPreviewSanitizer;
        this.responsePreviewSanitizer = responsePreviewSanitizer;
    }

    @Override
    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Boolean settingContentPreview = ctx.attr(SETTING_CONTENT_PREVIEW);
        if (Boolean.TRUE.equals(settingContentPreview)) {
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        }
        ctx.setAttr(SETTING_CONTENT_PREVIEW, true);
        if (!req.isEmpty()) {
            ContentPreviewer requestContentPreviewer = this.contentPreviewerFactory.requestContentPreviewer(ctx, req.headers());
            req = ContentPreviewingUtil.setUpRequestContentPreviewer(ctx, req, requestContentPreviewer, this.requestPreviewSanitizer);
            ctx.updateRequest(req);
        } else {
            ctx.logBuilder().requestContentPreview("");
        }
        ctx.logBuilder().defer(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
        HttpResponse res = (HttpResponse)((Client)this.unwrap()).execute(ctx, req);
        return ContentPreviewingUtil.setUpResponseContentPreviewer(this.contentPreviewerFactory, ctx, res, this.responsePreviewSanitizer);
    }
}

