/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.logging;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.logging.ContentPreviewingClient;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import karate.com.linecorp.armeria.common.util.Functions;

public final class ContentPreviewingClientBuilder {
    private static final BiFunction<? super RequestContext, String, ? extends @Nullable Object> DEFAULT_REQUEST_PREVIEW_SANITIZER = Functions.second();
    private static final BiFunction<? super RequestContext, String, ? extends @Nullable Object> DEFAULT_RESPONSE_PREVIEW_SANITIZER = Functions.second();
    private final ContentPreviewerFactory contentPreviewerFactory;
    private BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer = DEFAULT_REQUEST_PREVIEW_SANITIZER;
    private BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer = DEFAULT_RESPONSE_PREVIEW_SANITIZER;

    ContentPreviewingClientBuilder(ContentPreviewerFactory contentPreviewerFactory) {
        this.contentPreviewerFactory = contentPreviewerFactory;
    }

    public ContentPreviewingClientBuilder requestPreviewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer) {
        this.requestPreviewSanitizer = Objects.requireNonNull(requestPreviewSanitizer, "requestPreviewSanitizer");
        return this;
    }

    public ContentPreviewingClientBuilder responsePreviewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer) {
        this.responsePreviewSanitizer = Objects.requireNonNull(responsePreviewSanitizer, "responsePreviewSanitizer");
        return this;
    }

    public ContentPreviewingClientBuilder previewSanitizer(BiFunction<? super RequestContext, String, ? extends @Nullable Object> previewSanitizer) {
        Objects.requireNonNull(previewSanitizer, "previewSanitizer");
        this.requestPreviewSanitizer = previewSanitizer;
        this.responsePreviewSanitizer = previewSanitizer;
        return this;
    }

    public ContentPreviewingClient build(HttpClient delegate) {
        return new ContentPreviewingClient(delegate, this.contentPreviewerFactory, this.requestPreviewSanitizer, this.responsePreviewSanitizer);
    }

    public Function<? super HttpClient, ContentPreviewingClient> newDecorator() {
        return this::build;
    }
}

