/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.proxy;

import java.net.InetSocketAddress;
import java.util.Objects;
import karate.com.linecorp.armeria.client.proxy.ProxyConfig;
import karate.com.linecorp.armeria.client.proxy.ProxyType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public final class HAProxyConfig
extends ProxyConfig {
    private final InetSocketAddress proxyAddress;
    @Nullable
    private final InetSocketAddress sourceAddress;

    HAProxyConfig(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        this.sourceAddress = null;
    }

    HAProxyConfig(InetSocketAddress proxyAddress, InetSocketAddress sourceAddress) {
        Preconditions.checkArgument(sourceAddress.getAddress().getClass() == proxyAddress.getAddress().getClass(), "sourceAddress and proxyAddress should be the same type");
        this.proxyAddress = proxyAddress;
        this.sourceAddress = sourceAddress;
    }

    @Override
    public ProxyType proxyType() {
        return ProxyType.HAPROXY;
    }

    @Override
    public InetSocketAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Nullable
    public InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HAProxyConfig)) {
            return false;
        }
        HAProxyConfig that = (HAProxyConfig)o;
        return this.proxyAddress.equals(that.proxyAddress) && Objects.equals(this.sourceAddress, that.sourceAddress);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.sourceAddress);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("proxyType", (Object)this.proxyType()).add("proxyAddress", this.proxyAddress).add("sourceAddress", this.sourceAddress).toString();
    }
}

