/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.redirect;

import java.util.Objects;
import karate.com.linecorp.armeria.client.redirect.CyclicRedirectsException;
import karate.com.linecorp.armeria.client.redirect.RedirectsException;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;

@UnstableApi
public final class TooManyRedirectsException
extends RedirectsException {
    private static final long serialVersionUID = 3741211991690338730L;

    public static TooManyRedirectsException of(int maxRedirects, String originalUri, String ... redirectUris) {
        return TooManyRedirectsException.of(maxRedirects, originalUri, ImmutableList.copyOf(Objects.requireNonNull(redirectUris, "redirectUris")));
    }

    public static TooManyRedirectsException of(int maxRedirects, String originalUri, Iterable<String> redirectUris) {
        Preconditions.checkArgument(maxRedirects > 0, "maxRedirects: %s (expected: > 0)", maxRedirects);
        Objects.requireNonNull(originalUri, "originalUri");
        Objects.requireNonNull(redirectUris, "redirectUris");
        Preconditions.checkArgument(!Iterables.isEmpty(redirectUris), "redirectUris can't be empty.");
        return new TooManyRedirectsException(maxRedirects, originalUri, redirectUris);
    }

    private TooManyRedirectsException(int maxRedirects, String originalUri, Iterable<String> redirectUris) {
        super(TooManyRedirectsException.createMessage(maxRedirects, originalUri, redirectUris));
    }

    private static String createMessage(int maxRedirects, String originalUri, Iterable<String> redirectUris) {
        try (TemporaryThreadLocals threadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = threadLocals.stringBuilder();
            sb.append("maxRedirects: ");
            sb.append(maxRedirects);
            sb.append(System.lineSeparator());
            CyclicRedirectsException.addUris(sb, originalUri, redirectUris);
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptionSampler().isSampled(this.getClass())) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

