/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.time.Duration;
import java.util.Objects;
import karate.com.linecorp.armeria.client.retry.RetryConfig;
import karate.com.linecorp.armeria.client.retry.RetryConfigBuilder;
import karate.com.linecorp.armeria.client.retry.RetryConfigMapping;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public abstract class AbstractRetryingClientBuilder<O extends Response> {
    @Nullable
    private final RetryConfigBuilder<O> retryConfigBuilder;
    @Nullable
    private final RetryConfigMapping<O> mapping;

    AbstractRetryingClientBuilder(RetryConfig<O> retryConfig) {
        this.retryConfigBuilder = Objects.requireNonNull(retryConfig, "retryConfig").toBuilder();
        this.mapping = null;
    }

    AbstractRetryingClientBuilder(RetryConfigMapping<O> mapping) {
        this.mapping = Objects.requireNonNull(mapping, "mapping");
        this.retryConfigBuilder = null;
    }

    final RetryConfigMapping<O> mapping() {
        if (this.mapping == null) {
            RetryConfig config = this.retryConfig();
            assert (config != null);
            return (ctx, req) -> config;
        }
        return this.mapping;
    }

    @Nullable
    final RetryConfig<O> retryConfig() {
        if (this.retryConfigBuilder == null) {
            return null;
        }
        return this.retryConfigBuilder.build();
    }

    @Deprecated
    public AbstractRetryingClientBuilder<O> maxTotalAttempts(int maxTotalAttempts) {
        Preconditions.checkState(this.retryConfigBuilder != null, "You are using a RetryConfigMapping. You cannot set maxTotalAttempts.");
        Preconditions.checkArgument(maxTotalAttempts > 0, "maxTotalAttempts: %s (expected: > 0)", maxTotalAttempts);
        this.retryConfigBuilder.maxTotalAttempts(maxTotalAttempts);
        return this;
    }

    @Deprecated
    public AbstractRetryingClientBuilder<O> responseTimeoutMillisForEachAttempt(long responseTimeoutMillisForEachAttempt) {
        Preconditions.checkState(this.retryConfigBuilder != null, "You are using a RetryConfigMapping. You cannot set responseTimeoutMillisForEachAttempt.");
        Preconditions.checkArgument(responseTimeoutMillisForEachAttempt >= 0L, "responseTimeoutMillisForEachAttempt: %s (expected: >= 0)", responseTimeoutMillisForEachAttempt);
        this.retryConfigBuilder.responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt);
        return this;
    }

    @Deprecated
    public AbstractRetryingClientBuilder<O> responseTimeoutForEachAttempt(Duration responseTimeoutForEachAttempt) {
        Preconditions.checkState(this.retryConfigBuilder != null, "You are using a RetryConfigMapping, so you cannot set responseTimeoutForEachAttempt.");
        Preconditions.checkArgument(!Objects.requireNonNull(responseTimeoutForEachAttempt, "responseTimeoutForEachAttempt").isNegative(), "responseTimeoutForEachAttempt: %s (expected: >= 0)", (Object)responseTimeoutForEachAttempt);
        return this.responseTimeoutMillisForEachAttempt(responseTimeoutForEachAttempt.toMillis());
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    final MoreObjects.ToStringHelper toStringHelper() {
        if (this.retryConfigBuilder == null) {
            return MoreObjects.toStringHelper(this).add("mapping", this.mapping);
        }
        return this.retryConfigBuilder.toStringHelper();
    }
}

