/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.client.retry.AttemptLimitingBackoff;
import karate.com.linecorp.armeria.client.retry.BackoffSpec;
import karate.com.linecorp.armeria.client.retry.DefaultBackoffHolder;
import karate.com.linecorp.armeria.client.retry.ExponentialBackoff;
import karate.com.linecorp.armeria.client.retry.FibonacciBackoff;
import karate.com.linecorp.armeria.client.retry.FixedBackoff;
import karate.com.linecorp.armeria.client.retry.JitterAddingBackoff;
import karate.com.linecorp.armeria.client.retry.RandomBackoff;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Unwrappable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

@FunctionalInterface
public interface Backoff
extends Unwrappable {
    public static Backoff ofDefault() {
        return DefaultBackoffHolder.defaultBackoff;
    }

    public static Backoff withoutDelay() {
        return FixedBackoff.NO_DELAY;
    }

    public static Backoff fixed(long delayMillis) {
        return new FixedBackoff(delayMillis);
    }

    public static Backoff exponential(long initialDelayMillis, long maxDelayMillis) {
        return Backoff.exponential(initialDelayMillis, maxDelayMillis, 2.0);
    }

    public static Backoff exponential(long initialDelayMillis, long maxDelayMillis, double multiplier) {
        return new ExponentialBackoff(initialDelayMillis, maxDelayMillis, multiplier);
    }

    public static Backoff fibonacci(long initialDelayMillis, long maxDelayMillis) {
        return new FibonacciBackoff(initialDelayMillis, maxDelayMillis);
    }

    public static Backoff random(long minDelayMillis, long maxDelayMillis) {
        return Backoff.random(minDelayMillis, maxDelayMillis, ThreadLocalRandom::current);
    }

    public static Backoff random(long minDelayMillis, long maxDelayMillis, Supplier<Random> randomSupplier) {
        return new RandomBackoff(minDelayMillis, maxDelayMillis, randomSupplier);
    }

    public static Backoff of(String specification) {
        return BackoffSpec.parse(specification).build();
    }

    public long nextDelayMillis(int var1);

    @Override
    @Nullable
    default public <T> T as(Class<T> type) {
        return Unwrappable.super.as(type);
    }

    @Override
    default public Backoff unwrap() {
        return (Backoff)Unwrappable.super.unwrap();
    }

    default public Backoff withJitter(double jitterRate) {
        Preconditions.checkArgument(0.0 <= jitterRate && jitterRate <= 1.0, "jitterRate: %s (expected: >= 0.0 and <= 1.0)", (Object)jitterRate);
        return this.withJitter(-jitterRate, jitterRate, ThreadLocalRandom::current);
    }

    default public Backoff withJitter(double minJitterRate, double maxJitterRate) {
        return this.withJitter(minJitterRate, maxJitterRate, ThreadLocalRandom::current);
    }

    default public Backoff withJitter(double minJitterRate, double maxJitterRate, Supplier<Random> randomSupplier) {
        return new JitterAddingBackoff(this, minJitterRate, maxJitterRate, randomSupplier);
    }

    default public Backoff withMaxAttempts(int maxAttempts) {
        return new AttemptLimitingBackoff(this, maxAttempts);
    }
}

