/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.util.ArrayList;
import karate.com.linecorp.armeria.client.retry.AbstractBackoff;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.math.LongMath;

final class FibonacciBackoff
extends AbstractBackoff {
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private final long[] precomputedDelays;

    FibonacciBackoff(long initialDelayMillis, long maxDelayMillis) {
        Preconditions.checkArgument(initialDelayMillis >= 0L, "initialDelayMillis: %s (expected: >= 0)", initialDelayMillis);
        Preconditions.checkArgument(initialDelayMillis <= maxDelayMillis, "maxDelayMillis: %s (expected: >= %s)", maxDelayMillis, initialDelayMillis);
        this.initialDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        ArrayList<Long> precomputed = new ArrayList<Long>();
        precomputed.add(initialDelayMillis);
        precomputed.add(initialDelayMillis);
        for (int i = 2; i <= 30; ++i) {
            long delay = LongMath.saturatedAdd((Long)precomputed.get(i - 2), (Long)precomputed.get(i - 1));
            if (delay >= maxDelayMillis) {
                precomputed.add(maxDelayMillis);
                break;
            }
            precomputed.add(delay);
        }
        this.precomputedDelays = precomputed.stream().mapToLong(l -> l).toArray();
    }

    @Override
    protected long doNextDelayMillis(int numAttemptsSoFar) {
        long nextDelay = this.fibDelay(numAttemptsSoFar);
        return Math.min(nextDelay, this.maxDelayMillis);
    }

    private long fibDelay(int n) {
        int length = this.precomputedDelays.length;
        if (n < length) {
            return this.precomputedDelays[n - 1];
        }
        if (this.precomputedDelays[length - 1] == this.maxDelayMillis) {
            return this.maxDelayMillis;
        }
        long a = this.precomputedDelays[length - 2];
        long b = this.precomputedDelays[length - 1];
        for (int i = 0; i <= n - length; ++i) {
            long c = a;
            a = b;
            b += c;
        }
        return a;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("initialDelayMillis", this.initialDelayMillis).add("maxDelayMillis", this.maxDelayMillis).toString();
    }
}

