/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.util.Objects;
import java.util.Random;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.client.retry.AbstractBackoff;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

final class RandomBackoff
extends AbstractBackoff {
    private final LongSupplier nextDelay;
    private final long minDelayMillis;
    private final long maxDelayMillis;

    RandomBackoff(long minDelayMillis, long maxDelayMillis, Supplier<Random> randomSupplier) {
        Preconditions.checkArgument(minDelayMillis >= 0L, "minDelayMillis: %s (expected: >= 0)", minDelayMillis);
        Preconditions.checkArgument(minDelayMillis <= maxDelayMillis, "maxDelayMillis: %s (expected: >= %s)", maxDelayMillis, minDelayMillis);
        Objects.requireNonNull(randomSupplier, "randomSupplier");
        this.minDelayMillis = minDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        long bound = maxDelayMillis - minDelayMillis + 1L;
        this.nextDelay = minDelayMillis == maxDelayMillis ? () -> minDelayMillis : () -> RandomBackoff.nextLong((Random)randomSupplier.get(), bound) + minDelayMillis;
    }

    @Override
    protected long doNextDelayMillis(int numAttemptsSoFar) {
        return this.nextDelay.getAsLong();
    }

    static long nextLong(Random random, long bound) {
        assert (bound > 0L);
        long mask = bound - 1L;
        long result = random.nextLong();
        if ((bound & mask) == 0L) {
            result &= mask;
        } else {
            long u = result >>> 1;
            while (u + mask - (result = u % bound) < 0L) {
                u = random.nextLong() >>> 1;
            }
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("minDelayMillis", this.minDelayMillis).add("maxDelayMillis", this.maxDelayMillis).toString();
    }
}

