/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.time.Duration;
import java.util.Objects;
import karate.com.linecorp.armeria.client.retry.RetryConfig;
import karate.com.linecorp.armeria.client.retry.RetryRule;
import karate.com.linecorp.armeria.client.retry.RetryRuleWithContent;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public final class RetryConfigBuilder<T extends Response> {
    private int maxTotalAttempts = Flags.defaultMaxTotalAttempts();
    private long responseTimeoutMillisForEachAttempt = Flags.defaultResponseTimeoutMillis();
    private int maxContentLength;
    @Nullable
    private final RetryRule retryRule;
    @Nullable
    private final RetryRuleWithContent<T> retryRuleWithContent;

    RetryConfigBuilder(RetryRule retryRule) {
        this.retryRule = Objects.requireNonNull(retryRule, "retryRule");
        this.retryRuleWithContent = null;
        this.maxContentLength = 0;
    }

    RetryConfigBuilder(RetryRuleWithContent<T> retryRuleWithContent) {
        this.retryRule = null;
        this.retryRuleWithContent = Objects.requireNonNull(retryRuleWithContent, "retryRuleWithContent");
        this.maxContentLength = Integer.MAX_VALUE;
    }

    public RetryConfigBuilder<T> maxContentLength(int maxContentLength) {
        Objects.requireNonNull(this.retryRuleWithContent, "retryRuleWithContent");
        Preconditions.checkArgument(maxContentLength > 0, "maxContentLength: %s (expected: > 0)", maxContentLength);
        this.maxContentLength = maxContentLength;
        return this;
    }

    public RetryConfigBuilder<T> maxTotalAttempts(int maxTotalAttempts) {
        Preconditions.checkArgument(maxTotalAttempts > 0, "maxTotalAttempts: %s (expected: > 0)", maxTotalAttempts);
        this.maxTotalAttempts = maxTotalAttempts;
        return this;
    }

    public RetryConfigBuilder<T> responseTimeoutMillisForEachAttempt(long responseTimeoutMillisForEachAttempt) {
        Preconditions.checkArgument(responseTimeoutMillisForEachAttempt >= 0L, "responseTimeoutMillisForEachAttempt: %s (expected: >= 0)", responseTimeoutMillisForEachAttempt);
        this.responseTimeoutMillisForEachAttempt = responseTimeoutMillisForEachAttempt;
        return this;
    }

    public RetryConfigBuilder<T> responseTimeoutForEachAttempt(Duration responseTimeoutMillisForEachAttempt) {
        long millis = Objects.requireNonNull(responseTimeoutMillisForEachAttempt, "responseTimeoutMillisForEachAttempt").toMillis();
        Preconditions.checkArgument(millis >= 0L, "responseTimeoutForEachAttempt.toMillis(): %s (expected: >= 0)", millis);
        this.responseTimeoutMillisForEachAttempt = millis;
        return this;
    }

    public RetryConfig<T> build() {
        if (this.retryRule != null) {
            return new RetryConfig(this.retryRule, this.maxTotalAttempts, this.responseTimeoutMillisForEachAttempt);
        }
        assert (this.retryRuleWithContent != null);
        return new RetryConfig<T>(this.retryRuleWithContent, this.maxContentLength, this.maxTotalAttempts, this.responseTimeoutMillisForEachAttempt);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("retryRule", this.retryRule).add("retryRuleWithContent", this.retryRuleWithContent).add("maxTotalAttempts", this.maxTotalAttempts).add("responseTimeoutMillisForEachAttempt", this.responseTimeoutMillisForEachAttempt).add("maxContentLength", this.maxContentLength);
    }
}

