/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.util.Objects;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.common.annotation.Nullable;

public final class RetryDecision {
    private static final RetryDecision NO_RETRY = new RetryDecision(null);
    private static final RetryDecision NEXT = new RetryDecision(null);
    static final RetryDecision DEFAULT = new RetryDecision(Backoff.ofDefault());
    @Nullable
    private final Backoff backoff;

    public static RetryDecision retry(Backoff backoff) {
        if (backoff == Backoff.ofDefault()) {
            return DEFAULT;
        }
        return new RetryDecision(Objects.requireNonNull(backoff, "backoff"));
    }

    public static RetryDecision noRetry() {
        return NO_RETRY;
    }

    public static RetryDecision next() {
        return NEXT;
    }

    private RetryDecision(@Nullable Backoff backoff) {
        this.backoff = backoff;
    }

    @Nullable
    Backoff backoff() {
        return this.backoff;
    }

    public String toString() {
        if (this == NO_RETRY) {
            return "RetryDecision(NO_RETRY)";
        }
        if (this == NEXT) {
            return "RetryDecision(NEXT)";
        }
        return "RetryDecision(RETRY(" + this.backoff + "))";
    }
}

