/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.client.retry.RetryDecision;
import karate.com.linecorp.armeria.client.retry.RetryRule;
import karate.com.linecorp.armeria.client.retry.RetryRuleUtil;
import karate.com.linecorp.armeria.client.retry.RetryRuleWithContentBuilder;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.HttpStatusClass;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;

@FunctionalInterface
public interface RetryRuleWithContent<T extends Response> {
    public static <T extends Response> RetryRuleWithContent<T> onResponse(BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> retryFunction) {
        return RetryRuleWithContent.onResponse(retryFunction, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onResponse(BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> retryFunction, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onResponse(retryFunction)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatusClass(HttpStatusClass statusClass) {
        return RetryRuleWithContent.onStatusClass(statusClass, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatusClass(HttpStatusClass statusClass, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatusClass(statusClass)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatusClass(HttpStatusClass ... statusClasses) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatusClass(statusClasses)).thenBackoff();
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        return RetryRuleWithContent.onStatusClass(statusClasses, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatusClass(Iterable<HttpStatusClass> statusClasses, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatusClass(statusClasses)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onServerErrorStatus() {
        return RetryRuleWithContent.onServerErrorStatus(Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onServerErrorStatus(Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onServerErrorStatus()).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatus(HttpStatus ... statuses) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatus(statuses)).thenBackoff();
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatus(Iterable<HttpStatus> statuses) {
        return RetryRuleWithContent.onStatus(statuses, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatus(Iterable<HttpStatus> statuses, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatus(statuses)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        return RetryRuleWithContent.onStatus(statusFilter, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onStatus(statusFilter)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onException(Class<? extends Throwable> exception) {
        return RetryRuleWithContent.onException(exception, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onException(Class<? extends Throwable> exception, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onException(exception)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        return RetryRuleWithContent.onException(exceptionFilter, Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter, Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onException(exceptionFilter)).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onException() {
        return RetryRuleWithContent.onException(Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onException(Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onException()).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContent<T> onUnprocessed() {
        return RetryRuleWithContent.onUnprocessed(Backoff.ofDefault());
    }

    public static <T extends Response> RetryRuleWithContent<T> onUnprocessed(Backoff backoff) {
        return ((RetryRuleWithContentBuilder)RetryRuleWithContent.builder().onUnprocessed()).thenBackoff(backoff);
    }

    public static <T extends Response> RetryRuleWithContentBuilder<T> builder() {
        return RetryRuleWithContent.builder(HttpMethod.knownMethods());
    }

    public static <T extends Response> RetryRuleWithContentBuilder<T> builder(HttpMethod ... methods) {
        return RetryRuleWithContent.builder(ImmutableSet.copyOf(Objects.requireNonNull(methods, "methods")));
    }

    public static <T extends Response> RetryRuleWithContentBuilder<T> builder(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "methods can't be empty.");
        ImmutableSet<HttpMethod> httpMethods = Sets.immutableEnumSet(methods);
        return RetryRuleWithContent.builder((? super ClientRequestContext ctx, ? super RequestHeaders headers) -> httpMethods.contains((Object)headers.method()));
    }

    public static <T extends Response> RetryRuleWithContentBuilder<T> builder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        Objects.requireNonNull(requestHeadersFilter, "requestHeadersFilter");
        return new RetryRuleWithContentBuilder(requestHeadersFilter);
    }

    @SafeVarargs
    public static <T extends Response> RetryRuleWithContent<T> of(RetryRuleWithContent<T> ... retryRules) {
        Objects.requireNonNull(retryRules, "retryRules");
        Preconditions.checkArgument(retryRules.length > 0, "retryRules can't be empty.");
        if (retryRules.length == 1) {
            return retryRules[0];
        }
        return RetryRuleWithContent.of(ImmutableList.copyOf(retryRules));
    }

    public static <T extends Response> RetryRuleWithContent<T> of(Iterable<? extends RetryRuleWithContent<T>> retryRules) {
        Objects.requireNonNull(retryRules, "retryRules");
        Preconditions.checkArgument(!Iterables.isEmpty(retryRules), "retryRules should not be empty.");
        if (Iterables.size(retryRules) == 1) {
            return Iterables.get(retryRules, 0);
        }
        Iterable<? extends RetryRuleWithContent<T>> cast = retryRules;
        return Streams.stream(cast).reduce(RetryRuleWithContent::orElse).get();
    }

    default public RetryRuleWithContent<T> orElse(RetryRule other) {
        Objects.requireNonNull(other, "other");
        return RetryRuleUtil.orElse(this, other);
    }

    default public RetryRuleWithContent<T> orElse(RetryRuleWithContent<T> other) {
        Objects.requireNonNull(other, "other");
        return RetryRuleUtil.orElse(this, other);
    }

    public CompletionStage<RetryDecision> shouldRetry(ClientRequestContext var1, @Nullable T var2, @Nullable Throwable var3);

    default public boolean requiresResponseTrailers() {
        return false;
    }
}

