/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.retry;

import java.time.Duration;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import karate.com.linecorp.armeria.client.Client;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.client.HttpClient;
import karate.com.linecorp.armeria.client.ResponseTimeoutException;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.retry.AbstractRetryingClient;
import karate.com.linecorp.armeria.client.retry.Backoff;
import karate.com.linecorp.armeria.client.retry.RetryConfig;
import karate.com.linecorp.armeria.client.retry.RetryConfigMapping;
import karate.com.linecorp.armeria.client.retry.RetryDecision;
import karate.com.linecorp.armeria.client.retry.RetryRule;
import karate.com.linecorp.armeria.client.retry.RetryRuleWithContent;
import karate.com.linecorp.armeria.client.retry.RetryingClientBuilder;
import karate.com.linecorp.armeria.common.AggregatedHttpRequest;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.AggregationOptions;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpRequestDuplicator;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpResponseDuplicator;
import karate.com.linecorp.armeria.common.RequestHeadersBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.RequestLog;
import karate.com.linecorp.armeria.common.logging.RequestLogAccess;
import karate.com.linecorp.armeria.common.logging.RequestLogBuilder;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.common.stream.AbortedStreamException;
import karate.com.linecorp.armeria.internal.client.AggregatedHttpRequestDuplicator;
import karate.com.linecorp.armeria.internal.client.ClientPendingThrowableUtil;
import karate.com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import karate.com.linecorp.armeria.internal.client.ClientUtil;
import karate.com.linecorp.armeria.internal.client.TruncatingHttpResponse;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.io.netty.handler.codec.DateFormatter;
import karate.io.netty.util.concurrent.EventExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryingClient
extends AbstractRetryingClient<HttpRequest, HttpResponse>
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RetryingClient.class);
    private final boolean useRetryAfter;

    public static RetryingClientBuilder builder(RetryConfig<HttpResponse> retryConfig) {
        return new RetryingClientBuilder(retryConfig);
    }

    public static RetryingClientBuilder builder(RetryRule retryRule) {
        return new RetryingClientBuilder(RetryConfig.builder0(retryRule).build());
    }

    public static RetryingClientBuilder builder(RetryRuleWithContent<HttpResponse> retryRuleWithContent) {
        return new RetryingClientBuilder(RetryConfig.builder0(retryRuleWithContent).build());
    }

    public static RetryingClientBuilder builder(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxContentLength) {
        Preconditions.checkArgument(maxContentLength > 0, "maxContentLength: %s (expected: > 0)", maxContentLength);
        return new RetryingClientBuilder(RetryConfig.builder0(retryRuleWithContent).maxContentLength(maxContentLength).build());
    }

    public static RetryingClientBuilder builderWithMapping(RetryConfigMapping<HttpResponse> mapping) {
        return new RetryingClientBuilder(mapping);
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule) {
        return RetryingClient.builder(retryRule).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent) {
        return RetryingClient.builder(retryRuleWithContent).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule, int maxTotalAttempts) {
        return RetryingClient.builder(retryRule).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxTotalAttempts) {
        return RetryingClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRule retryRule, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingClient.builder(retryRule).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    @Deprecated
    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryRuleWithContent<HttpResponse> retryRuleWithContent, int maxTotalAttempts, long responseTimeoutMillisForEachAttempt) {
        return RetryingClient.builder(retryRuleWithContent).maxTotalAttempts(maxTotalAttempts).responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecorator(RetryConfig<HttpResponse> retryConfig) {
        return RetryingClient.builder(retryConfig).newDecorator();
    }

    public static Function<? super HttpClient, RetryingClient> newDecoratorWithMapping(RetryConfigMapping<HttpResponse> mapping) {
        return RetryingClient.builderWithMapping(mapping).newDecorator();
    }

    RetryingClient(HttpClient delegate, RetryConfigMapping<HttpResponse> mapping, @Nullable RetryConfig<HttpResponse> retryConfig, boolean useRetryAfter) {
        super(delegate, mapping, retryConfig);
        this.useRetryAfter = useRetryAfter;
    }

    @Override
    protected HttpResponse doExecute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse res = HttpResponse.of(responseFuture, (EventExecutor)ctx.eventLoop());
        if (ctx.exchangeType().isRequestStreaming()) {
            HttpRequestDuplicator reqDuplicator = req.toDuplicator(ctx.eventLoop().withoutContext(), 0L);
            this.doExecute0(ctx, reqDuplicator, req, res, responseFuture);
        } else {
            req.aggregate(AggregationOptions.usePooledObjects(ctx.alloc(), ctx.eventLoop())).handle((agg, cause) -> {
                if (cause != null) {
                    RetryingClient.handleException(ctx, null, responseFuture, cause, true);
                } else {
                    AggregatedHttpRequestDuplicator reqDuplicator = new AggregatedHttpRequestDuplicator((AggregatedHttpRequest)agg);
                    this.doExecute0(ctx, reqDuplicator, req, res, responseFuture);
                }
                return null;
            });
        }
        return res;
    }

    private void doExecute0(ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future) {
        HttpResponse response;
        ClientRequestContext derivedCtx;
        HttpRequest duplicateReq;
        boolean initialAttempt;
        int totalAttempts = RetryingClient.getTotalAttempts(ctx);
        boolean bl = initialAttempt = totalAttempts <= 1;
        if (originalReq.whenComplete().isCompletedExceptionally()) {
            originalReq.whenComplete().handle((unused, cause) -> {
                RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, initialAttempt);
                return null;
            });
            return;
        }
        if (returnedRes.isComplete()) {
            returnedRes.whenComplete().handle((result, cause) -> {
                Throwable abortCause = cause != null ? cause : AbortedStreamException.get();
                RetryingClient.handleException(ctx, rootReqDuplicator, future, abortCause, initialAttempt);
                return null;
            });
            return;
        }
        if (!this.setResponseTimeout(ctx)) {
            RetryingClient.handleException(ctx, rootReqDuplicator, future, ResponseTimeoutException.get(), initialAttempt);
            return;
        }
        if (initialAttempt) {
            duplicateReq = rootReqDuplicator.duplicate();
        } else {
            RequestHeadersBuilder newHeaders = originalReq.headers().toBuilder();
            newHeaders.setInt(ARMERIA_RETRY_COUNT, totalAttempts - 1);
            duplicateReq = rootReqDuplicator.duplicate(newHeaders.build());
        }
        try {
            derivedCtx = RetryingClient.newDerivedContext(ctx, duplicateReq, ctx.rpcRequest(), initialAttempt);
        }
        catch (Throwable t) {
            RetryingClient.handleException(ctx, rootReqDuplicator, future, t, initialAttempt);
            return;
        }
        EndpointGroup endpointGroup = derivedCtx.endpointGroup();
        ClientRequestContextExtension ctxExtension = derivedCtx.as(ClientRequestContextExtension.class);
        if (!initialAttempt && ctxExtension != null && endpointGroup != null && derivedCtx.endpoint() == null) {
            ClientPendingThrowableUtil.removePendingThrowable(derivedCtx);
            response = ClientUtil.initContextAndExecuteWithFallback((Client)this.unwrap(), ctxExtension, endpointGroup, HttpResponse::of, (context, cause) -> HttpResponse.ofFailure(cause));
        } else {
            response = ClientUtil.executeWithFallback((Client)this.unwrap(), derivedCtx, (context, cause) -> HttpResponse.ofFailure(cause));
        }
        RetryConfig<HttpResponse> config = this.mappedRetryConfig(ctx);
        if (!ctx.exchangeType().isResponseStreaming() || config.requiresResponseTrailers()) {
            response.aggregate().handle((aggregated, cause) -> {
                if (cause != null) {
                    derivedCtx.logBuilder().endResponse((Throwable)cause);
                    this.handleResponseWithoutContent(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, HttpResponse.ofFailure(cause), (Throwable)cause);
                    return null;
                }
                this.handleResponse(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, null, (AggregatedHttpResponse)aggregated);
                return null;
            });
        } else {
            this.handleResponse(config, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, response, null);
        }
    }

    private void handleResponseWithoutContent(RetryConfig<HttpResponse> config, ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, ClientRequestContext derivedCtx, HttpResponse response, @Nullable Throwable responseCause) {
        try {
            RetryRule retryRule = RetryingClient.retryRule(config);
            CompletionStage<RetryDecision> f = retryRule.shouldRetry(derivedCtx, responseCause);
            f.handle((decision, shouldRetryCause) -> {
                RetryingClient.warnIfExceptionIsRaised(retryRule, shouldRetryCause);
                this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, response);
                return null;
            });
        }
        catch (Throwable cause) {
            response.abort();
            RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, false);
        }
    }

    private void handleResponse(RetryConfig<HttpResponse> retryConfig, ClientRequestContext ctx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, ClientRequestContext derivedCtx, @Nullable HttpResponse response, @Nullable AggregatedHttpResponse aggregatedRes) {
        assert (response != null || aggregatedRes != null);
        RequestLogProperty logProperty = retryConfig.requiresResponseTrailers() ? RequestLogProperty.RESPONSE_END_TIME : RequestLogProperty.RESPONSE_HEADERS;
        derivedCtx.log().whenAvailable(logProperty).thenAccept(log -> {
            HttpResponse response0;
            Throwable responseCause;
            Throwable throwable = responseCause = log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) ? log.responseCause() : null;
            if (retryConfig.needsContentInRule() && responseCause == null) {
                RetryRuleWithContent<HttpResponse> ruleWithContent = retryConfig.retryRuleWithContent();
                assert (ruleWithContent != null);
                if (aggregatedRes != null) {
                    try {
                        ruleWithContent.shouldRetry(derivedCtx, aggregatedRes.toHttpResponse(), null).handle((decision, cause) -> {
                            RetryingClient.warnIfExceptionIsRaised(ruleWithContent, cause);
                            this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, aggregatedRes.toHttpResponse());
                            return null;
                        });
                    }
                    catch (Throwable cause2) {
                        RetryingClient.handleException(ctx, rootReqDuplicator, future, cause2, false);
                    }
                    return;
                }
                assert (response != null);
                HttpResponseDuplicator duplicator = response.toDuplicator(derivedCtx.eventLoop().withoutContext(), derivedCtx.maxResponseLength());
                try {
                    TruncatingHttpResponse truncatingHttpResponse = new TruncatingHttpResponse(duplicator.duplicate(), retryConfig.maxContentLength());
                    HttpResponse duplicated = duplicator.duplicate();
                    duplicator.close();
                    ruleWithContent.shouldRetry(derivedCtx, truncatingHttpResponse, null).handle((decision, cause) -> {
                        RetryingClient.warnIfExceptionIsRaised(ruleWithContent, cause);
                        truncatingHttpResponse.abort();
                        this.handleRetryDecision((RetryDecision)decision, ctx, derivedCtx, rootReqDuplicator, originalReq, returnedRes, future, duplicated);
                        return null;
                    });
                }
                catch (Throwable cause3) {
                    duplicator.abort(cause3);
                    RetryingClient.handleException(ctx, rootReqDuplicator, future, cause3, false);
                }
                return;
            }
            if (aggregatedRes != null) {
                response0 = aggregatedRes.toHttpResponse();
            } else {
                response0 = response;
                assert (response0 != null);
            }
            this.handleResponseWithoutContent(retryConfig, ctx, rootReqDuplicator, originalReq, returnedRes, future, derivedCtx, response0, responseCause);
        });
    }

    private static void warnIfExceptionIsRaised(Object retryRule, @Nullable Throwable cause) {
        if (cause != null) {
            logger.warn("Unexpected exception is raised from {}.", retryRule, (Object)cause);
        }
    }

    private static void handleException(ClientRequestContext ctx, @Nullable HttpRequestDuplicator rootReqDuplicator, CompletableFuture<HttpResponse> future, Throwable cause, boolean endRequestLog) {
        future.completeExceptionally(cause);
        if (rootReqDuplicator != null) {
            rootReqDuplicator.abort(cause);
        }
        if (endRequestLog) {
            ctx.logBuilder().endRequest(cause);
        }
        ctx.logBuilder().endResponse(cause);
    }

    private void handleRetryDecision(@Nullable RetryDecision decision, ClientRequestContext ctx, ClientRequestContext derivedCtx, HttpRequestDuplicator rootReqDuplicator, HttpRequest originalReq, HttpResponse returnedRes, CompletableFuture<HttpResponse> future, HttpResponse originalRes) {
        long millisAfter;
        long nextDelay;
        Backoff backoff;
        Backoff backoff2 = backoff = decision != null ? decision.backoff() : null;
        if (backoff != null && (nextDelay = this.getNextDelay(ctx, backoff, millisAfter = this.useRetryAfter ? RetryingClient.getRetryAfterMillis(derivedCtx) : -1L)) >= 0L) {
            RetryingClient.abortResponse(originalRes, derivedCtx);
            RetryingClient.scheduleNextRetry(ctx, cause -> RetryingClient.handleException(ctx, rootReqDuplicator, future, cause, false), () -> this.doExecute0(ctx, rootReqDuplicator, originalReq, returnedRes, future), nextDelay);
            return;
        }
        RetryingClient.onRetryingComplete(ctx);
        future.complete(originalRes);
        rootReqDuplicator.close();
    }

    private static void abortResponse(HttpResponse originalRes, ClientRequestContext derivedCtx) {
        RequestLogBuilder logBuilder = derivedCtx.logBuilder();
        logBuilder.responseContent(null, null);
        logBuilder.responseContentPreview(null);
        originalRes.abort();
    }

    private static long getRetryAfterMillis(ClientRequestContext ctx) {
        String value;
        RequestLogAccess log = ctx.log();
        RequestLog requestLog = log.getIfAvailable(RequestLogProperty.RESPONSE_HEADERS);
        String string = value = requestLog != null ? requestLog.responseHeaders().get(HttpHeaderNames.RETRY_AFTER) : null;
        if (value != null) {
            try {
                return Duration.ofSeconds(Integer.parseInt(value)).toMillis();
            }
            catch (Exception exception) {
                try {
                    Date date = DateFormatter.parseHttpDate(value);
                    if (date != null) {
                        return date.getTime() - System.currentTimeMillis();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                logger.debug("The retryAfter: {}, from the server is neither an HTTP date nor a second.", (Object)value);
            }
        }
        return -1L;
    }

    private static RetryRule retryRule(RetryConfig<HttpResponse> retryConfig) {
        if (retryConfig.needsContentInRule()) {
            return retryConfig.fromRetryRuleWithContent();
        }
        RetryRule rule = retryConfig.retryRule();
        assert (rule != null);
        return rule;
    }
}

