/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.websocket;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.client.ClientBuilderParams;
import karate.com.linecorp.armeria.client.RequestOptions;
import karate.com.linecorp.armeria.client.WebClient;
import karate.com.linecorp.armeria.client.endpoint.EndpointGroup;
import karate.com.linecorp.armeria.client.websocket.DefaultWebSocketClient;
import karate.com.linecorp.armeria.client.websocket.WebSocketClientBuilder;
import karate.com.linecorp.armeria.client.websocket.WebSocketSession;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.Scheme;
import karate.com.linecorp.armeria.common.SerializationFormat;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.Unwrappable;
import karate.com.linecorp.armeria.internal.client.ClientUtil;

@UnstableApi
public interface WebSocketClient
extends ClientBuilderParams,
Unwrappable {
    public static WebSocketClient of() {
        return DefaultWebSocketClient.DEFAULT;
    }

    public static WebSocketClient of(String uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(URI uri) {
        return WebSocketClient.builder(uri).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(scheme, endpointGroup).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return WebSocketClient.builder(protocol, endpointGroup).build();
    }

    public static WebSocketClient of(String scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(Scheme scheme, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(scheme, endpointGroup, path).build();
    }

    public static WebSocketClient of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return WebSocketClient.builder(protocol, endpointGroup, path).build();
    }

    public static WebSocketClientBuilder builder() {
        return WebSocketClient.builder(ClientUtil.UNDEFINED_URI);
    }

    public static WebSocketClientBuilder builder(String uri) {
        return WebSocketClient.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static WebSocketClientBuilder builder(URI uri) {
        return new WebSocketClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, null);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup);
    }

    public static WebSocketClientBuilder builder(String scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        return WebSocketClient.builder(Scheme.parse(scheme), endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new WebSocketClientBuilder(scheme, endpointGroup, path);
    }

    public static WebSocketClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        return WebSocketClient.builder(Scheme.of(SerializationFormat.WS, protocol), endpointGroup, path);
    }

    default public CompletableFuture<WebSocketSession> connect(String path) {
        return this.connect(path, HttpHeaders.of());
    }

    default public CompletableFuture<WebSocketSession> connect(String path, HttpHeaders headers) {
        return this.connect(path, headers, RequestOptions.of());
    }

    public CompletableFuture<WebSocketSession> connect(String var1, HttpHeaders var2, RequestOptions var3);

    @Override
    public WebClient unwrap();
}

