/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.client.websocket;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.client.ClientRequestContext;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.stream.PublisherBasedStreamMessage;
import karate.com.linecorp.armeria.common.stream.StreamMessage;
import karate.com.linecorp.armeria.common.websocket.WebSocket;
import karate.com.linecorp.armeria.common.websocket.WebSocketFrame;
import karate.com.linecorp.armeria.common.websocket.WebSocketWriter;
import karate.com.linecorp.armeria.internal.common.websocket.WebSocketFrameEncoder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.org.reactivestreams.Publisher;

@UnstableApi
public final class WebSocketSession {
    private final ClientRequestContext ctx;
    private final ResponseHeaders responseHeaders;
    @Nullable
    private final String subprotocol;
    private final WebSocket inbound;
    private final CompletableFuture<StreamMessage<HttpData>> outboundFuture;
    private final WebSocketFrameEncoder encoder;

    WebSocketSession(ClientRequestContext ctx, ResponseHeaders responseHeaders, WebSocket inbound, CompletableFuture<StreamMessage<HttpData>> outboundFuture, WebSocketFrameEncoder encoder) {
        this.ctx = ctx;
        this.responseHeaders = responseHeaders;
        this.subprotocol = responseHeaders.get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        this.inbound = inbound;
        this.outboundFuture = outboundFuture;
        this.encoder = encoder;
    }

    public ClientRequestContext context() {
        return this.ctx;
    }

    public ResponseHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Nullable
    public String subprotocol() {
        return this.subprotocol;
    }

    public WebSocket inbound() {
        return this.inbound;
    }

    public WebSocketWriter outbound() {
        WebSocketWriter writer = WebSocket.streaming();
        this.setOutbound(writer);
        return writer;
    }

    public void setOutbound(Publisher<? extends WebSocketFrame> outbound) {
        Objects.requireNonNull(outbound, "outbound");
        if (this.outboundFuture.isDone()) {
            if (outbound instanceof StreamMessage) {
                ((StreamMessage)outbound).abort();
            }
            throw new IllegalStateException("outbound() or setOutbound() has been already called.");
        }
        PublisherBasedStreamMessage<? extends WebSocketFrame> streamMessage = outbound instanceof StreamMessage ? (PublisherBasedStreamMessage<? extends WebSocketFrame>)outbound : new PublisherBasedStreamMessage<WebSocketFrame>(outbound);
        if (!this.outboundFuture.complete(streamMessage.map(webSocketFrame -> HttpData.wrap(this.encoder.encode(this.ctx, (WebSocketFrame)webSocketFrame))))) {
            streamMessage.abort();
            throw new IllegalStateException("outbound() or setOutbound() has been already called.");
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ctx", this.ctx).add("responseHeaders", this.responseHeaders).add("subprotocol", this.subprotocol).add("inbound", this.inbound).add("outboundFuture", this.outboundFuture).add("encoder", this.encoder).toString();
    }
}

