/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractContextAwareExecutor<E extends Executor>
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractContextAwareExecutor.class);
    private final E executor;

    AbstractContextAwareExecutor(E executor) {
        this.executor = (Executor)Objects.requireNonNull(executor, "executor");
    }

    @Nullable
    abstract RequestContext contextOrNull();

    public final E withoutContext() {
        return this.executor;
    }

    final Runnable makeContextAware(Runnable task) {
        RequestContext context = this.contextOrNull();
        return context == null ? task : context.makeContextAware(task);
    }

    @Override
    public final void execute(Runnable command) {
        this.executor.execute(this.makeContextAware(command));
    }

    static enum LogRequestContextWarningOnce implements Supplier<RequestContext>
    {
        INSTANCE;


        @Override
        @Nullable
        public RequestContext get() {
            ClassLoaderHack.loadMe();
            return null;
        }

        private static final class ClassLoaderHack {
            private ClassLoaderHack() {
            }

            static void loadMe() {
            }

            static {
                logger.warn("Attempted to propagate request context to an executor task, but no request context available. If this executor is used for non-request-related tasks then it's safe to ignore this", (Throwable)new NoRequestContextException());
            }
        }

        private static final class NoRequestContextException
        extends RuntimeException {
            private static final long serialVersionUID = 2804189311774982052L;

            private NoRequestContextException() {
            }
        }
    }
}

