/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.HttpEntity;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.NoHttpContentException;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Objects;

abstract class AbstractHttpEntity<T>
implements HttpEntity<T> {
    private final HttpHeaders headers;
    @Nullable
    private final T content;
    private final HttpHeaders trailers;

    AbstractHttpEntity(HttpHeaders headers, @Nullable T content, HttpHeaders trailers) {
        this.headers = headers;
        this.content = content;
        this.trailers = trailers;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T content() {
        if (this.content == null) {
            throw new NoHttpContentException("No content present.");
        }
        return this.content;
    }

    @Override
    public boolean hasContent() {
        return this.content != null;
    }

    @Override
    public HttpHeaders trailers() {
        return this.trailers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractHttpEntity)) {
            return false;
        }
        AbstractHttpEntity that = (AbstractHttpEntity)o;
        return this.headers.equals(that.headers) && Objects.equal(this.content, that.content) && this.trailers.equals(that.trailers);
    }

    public int hashCode() {
        return Objects.hashCode(this.headers, this.content, this.trailers);
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this).omitNullValues().add("headers", this.headers).add("content", this.content);
        if (!this.trailers.isEmpty()) {
            stringHelper.add("trailers", this.trailers);
        }
        return stringHelper.toString();
    }
}

