/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import karate.com.fasterxml.jackson.core.JsonProcessingException;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpHeadersBuilder;
import karate.com.linecorp.armeria.common.HttpMessageSetters;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.common.JacksonUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.org.reactivestreams.Publisher;

@UnstableApi
public abstract class AbstractHttpMessageBuilder
implements HttpMessageSetters {
    @Nullable
    private HttpData content;
    @Nullable
    private Publisher<? extends HttpData> publisher;
    @Nullable
    private HttpHeadersBuilder httpTrailers;

    protected AbstractHttpMessageBuilder() {
    }

    @Nullable
    final HttpData content() {
        return this.content;
    }

    @Nullable
    protected final Publisher<? extends HttpData> publisher() {
        return this.publisher;
    }

    @Nullable
    final HttpHeadersBuilder httpTrailers() {
        return this.httpTrailers;
    }

    abstract HttpHeadersBuilder headersBuilder();

    @Override
    public AbstractHttpMessageBuilder header(CharSequence name, Object value) {
        this.headersBuilder().addObject(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"));
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder headers(Iterable<? extends Map.Entry<? extends CharSequence, String>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().add(headers);
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder content(String content) {
        return this.content(MediaType.PLAIN_TEXT_UTF_8, content);
    }

    @Override
    public AbstractHttpMessageBuilder content(MediaType contentType, CharSequence content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), content));
    }

    @Override
    public AbstractHttpMessageBuilder content(MediaType contentType, String content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), content));
    }

    @Override
    @FormatMethod
    public AbstractHttpMessageBuilder content(@FormatString String format, Object ... content) {
        return this.content(MediaType.PLAIN_TEXT_UTF_8, format, content);
    }

    @Override
    @FormatMethod
    public AbstractHttpMessageBuilder content(MediaType contentType, @FormatString String format, Object ... content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.of(contentType.charset(StandardCharsets.UTF_8), format, content));
    }

    @Override
    public AbstractHttpMessageBuilder content(MediaType contentType, byte[] content) {
        Objects.requireNonNull(content, "content");
        return this.content(contentType, HttpData.wrap(content));
    }

    @Override
    public AbstractHttpMessageBuilder content(MediaType contentType, HttpData content) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(content, "content");
        Preconditions.checkState(this.publisher == null, "publisher has been set already");
        this.headersBuilder().contentType(contentType);
        this.content = content;
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder content(Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(publisher, "publisher");
        Preconditions.checkState(this.content == null, "content has been set already");
        this.publisher = publisher;
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder content(MediaType contentType, Publisher<? extends HttpData> publisher) {
        Objects.requireNonNull(contentType, "contentType");
        Objects.requireNonNull(publisher, "publisher");
        Preconditions.checkState(this.content == null, "content has been set already");
        this.headersBuilder().contentType(contentType);
        this.publisher = publisher;
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder contentJson(Object content) {
        Objects.requireNonNull(content, "content");
        Preconditions.checkState(this.publisher == null, "publisher has been set already");
        try {
            return this.content(MediaType.JSON, HttpData.wrap(JacksonUtil.writeValueAsBytes(content)));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("failed to serialize " + content, e);
        }
    }

    @Override
    public AbstractHttpMessageBuilder trailer(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        if (this.httpTrailers == null) {
            this.httpTrailers = HttpHeaders.builder();
        }
        this.httpTrailers.addObject(name, value);
        return this;
    }

    @Override
    public AbstractHttpMessageBuilder trailers(Iterable<? extends Map.Entry<? extends CharSequence, String>> trailers) {
        Objects.requireNonNull(trailers, "trailers");
        if (this.httpTrailers == null) {
            this.httpTrailers = HttpHeaders.builder();
        }
        this.httpTrailers.add(trailers);
        return this;
    }
}

