/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLSession;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.RequestId;
import karate.com.linecorp.armeria.common.RequestTarget;
import karate.com.linecorp.armeria.common.RequestTargetForm;
import karate.com.linecorp.armeria.common.RpcRequest;
import karate.com.linecorp.armeria.common.Scheme;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.metric.NoopMeterRegistry;
import karate.com.linecorp.armeria.internal.common.DefaultRequestTarget;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.buffer.ByteBufAllocator;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelConfig;
import karate.io.netty.channel.ChannelFuture;
import karate.io.netty.channel.ChannelId;
import karate.io.netty.channel.ChannelMetadata;
import karate.io.netty.channel.ChannelPipeline;
import karate.io.netty.channel.ChannelProgressivePromise;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.channel.DefaultChannelId;
import karate.io.netty.channel.EventLoop;
import karate.io.netty.util.Attribute;
import karate.io.netty.util.AttributeKey;
import karate.io.netty.util.NetUtil;

public abstract class AbstractRequestContextBuilder {
    private static final String FALLBACK_AUTHORITY = "127.0.0.1";
    private final boolean server;
    @Nullable
    private final HttpRequest req;
    @Nullable
    private final RpcRequest rpcReq;
    private SessionProtocol sessionProtocol;
    @Nullable
    private RequestId id;
    private HttpMethod method;
    private final String authority;
    private final RequestTarget reqTarget;
    private MeterRegistry meterRegistry = NoopMeterRegistry.get();
    @Nullable
    private EventLoop eventLoop;
    private ByteBufAllocator alloc = ByteBufAllocator.DEFAULT;
    @Nullable
    private InetSocketAddress remoteAddress;
    @Nullable
    private InetSocketAddress localAddress;
    @Nullable
    private SSLSession sslSession;
    private boolean requestStartTimeSet;
    private long requestStartTimeNanos;
    private long requestStartTimeMicros;
    @Nullable
    private Channel channel;
    private boolean timedOut;

    protected AbstractRequestContextBuilder(boolean server, HttpRequest req) {
        Objects.requireNonNull(req, "req");
        this.server = server;
        this.rpcReq = null;
        this.sessionProtocol = SessionProtocol.H2C;
        this.method = req.headers().method();
        this.authority = MoreObjects.firstNonNull(req.headers().authority(), FALLBACK_AUTHORITY);
        String rawPath = req.headers().path();
        RequestTarget reqTarget = server ? RequestTarget.forServer(rawPath) : RequestTarget.forClient(rawPath);
        Preconditions.checkArgument(reqTarget != null, "request.path is not valid: %s", (Object)rawPath);
        Preconditions.checkArgument(reqTarget.form() != RequestTargetForm.ABSOLUTE, "request.path must not contain scheme or authority: %s", (Object)rawPath);
        String newRawPath = reqTarget.pathAndQuery();
        this.req = newRawPath.equals(rawPath) ? req : req.withHeaders(req.headers().toBuilder().path(newRawPath));
        this.reqTarget = reqTarget;
    }

    protected AbstractRequestContextBuilder(boolean server, RpcRequest rpcReq, URI uri) {
        this.server = server;
        this.req = null;
        this.rpcReq = Objects.requireNonNull(rpcReq, "rpcReq");
        this.method = HttpMethod.POST;
        Objects.requireNonNull(uri, "uri");
        this.authority = MoreObjects.firstNonNull(uri.getRawAuthority(), FALLBACK_AUTHORITY);
        this.sessionProtocol = AbstractRequestContextBuilder.getSessionProtocol(uri);
        if (server) {
            RequestTarget reqTarget;
            String path = uri.getRawPath();
            String query = uri.getRawQuery();
            if (query != null) {
                path = path + '?' + query;
            }
            if ((reqTarget = RequestTarget.forServer(path)) == null) {
                throw new IllegalArgumentException("invalid uri: " + uri);
            }
            this.reqTarget = reqTarget;
        } else {
            this.reqTarget = DefaultRequestTarget.createWithoutValidation(RequestTargetForm.ORIGIN, null, null, null, -1, uri.getRawPath(), uri.getRawPath(), null, uri.getRawQuery(), uri.getRawFragment());
        }
    }

    private static SessionProtocol getSessionProtocol(URI uri) {
        String schemeStr = uri.getScheme();
        if (schemeStr != null && schemeStr.indexOf(43) < 0) {
            SessionProtocol parsed = SessionProtocol.find(schemeStr);
            if (parsed == null) {
                throw AbstractRequestContextBuilder.newInvalidSchemeException(uri);
            }
            return parsed;
        }
        Scheme parsed = Scheme.tryParse(schemeStr);
        if (parsed == null) {
            throw AbstractRequestContextBuilder.newInvalidSchemeException(uri);
        }
        return parsed.sessionProtocol();
    }

    private static IllegalArgumentException newInvalidSchemeException(URI uri) {
        return new IllegalArgumentException("uri.scheme is not valid: " + uri);
    }

    protected final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    public AbstractRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        return this;
    }

    @Nullable
    protected final EventLoop eventLoop() {
        return this.eventLoop;
    }

    public AbstractRequestContextBuilder eventLoop(EventLoop eventLoop) {
        this.eventLoop = Objects.requireNonNull(eventLoop, "eventLoop");
        return this;
    }

    protected final ByteBufAllocator alloc() {
        return this.alloc;
    }

    public AbstractRequestContextBuilder alloc(ByteBufAllocator alloc) {
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        return this;
    }

    @Nullable
    protected final HttpRequest request() {
        return this.req;
    }

    @Nullable
    protected final RpcRequest rpcRequest() {
        return this.rpcReq;
    }

    protected final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    public AbstractRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        if (this.rpcReq != null) {
            Preconditions.checkArgument(sessionProtocol == this.sessionProtocol, "sessionProtocol: %s (expected: same as the session protocol specified in 'uri')", (Object)sessionProtocol);
        } else {
            this.sessionProtocol = sessionProtocol;
        }
        return this;
    }

    protected final InetSocketAddress remoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = this.server ? new InetSocketAddress(NetUtil.LOCALHOST, AbstractRequestContextBuilder.randomClientPort()) : new InetSocketAddress(NetUtil.LOCALHOST, AbstractRequestContextBuilder.guessServerPort(this.sessionProtocol, this.authority));
        }
        return this.remoteAddress;
    }

    public AbstractRequestContextBuilder remoteAddress(InetSocketAddress remoteAddress) {
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
        return this;
    }

    protected final InetSocketAddress localAddress() {
        if (this.localAddress == null) {
            this.localAddress = this.server ? new InetSocketAddress(NetUtil.LOCALHOST, AbstractRequestContextBuilder.guessServerPort(this.sessionProtocol, this.authority)) : new InetSocketAddress(NetUtil.LOCALHOST, AbstractRequestContextBuilder.randomClientPort());
        }
        return this.localAddress;
    }

    public AbstractRequestContextBuilder localAddress(InetSocketAddress localAddress) {
        this.localAddress = Objects.requireNonNull(localAddress, "localAddress");
        return this;
    }

    private static int guessServerPort(SessionProtocol sessionProtocol, @Nullable String authority) {
        int port;
        if (authority == null) {
            return sessionProtocol.defaultPort();
        }
        int lastColonPos = authority.lastIndexOf(58);
        if (lastColonPos < 0) {
            return sessionProtocol.defaultPort();
        }
        try {
            port = Integer.parseInt(authority.substring(lastColonPos + 1));
        }
        catch (NumberFormatException e) {
            return sessionProtocol.defaultPort();
        }
        if (port <= 0 || port >= 65536) {
            return sessionProtocol.defaultPort();
        }
        return port;
    }

    private static int randomClientPort() {
        return ThreadLocalRandom.current().nextInt(32768, 65536);
    }

    @Nullable
    protected final SSLSession sslSession() {
        Preconditions.checkState(!this.sessionProtocol.isTls() || this.sslSession != null, "sslSession must be set for a TLS-enabled protocol: %s", (Object)this.sessionProtocol);
        return this.sessionProtocol.isTls() ? this.sslSession : null;
    }

    public AbstractRequestContextBuilder sslSession(SSLSession sslSession) {
        this.sslSession = Objects.requireNonNull(sslSession, "sslSession");
        switch (this.sessionProtocol) {
            case HTTP: {
                this.sessionProtocol(SessionProtocol.HTTPS);
                break;
            }
            case H1C: {
                this.sessionProtocol(SessionProtocol.H1);
                break;
            }
            case H2C: {
                this.sessionProtocol(SessionProtocol.H2);
            }
        }
        return this;
    }

    protected final boolean isRequestStartTimeSet() {
        return this.requestStartTimeSet;
    }

    protected final long requestStartTimeNanos() {
        Preconditions.checkState(this.isRequestStartTimeSet(), "requestStartTime is not set.");
        return this.requestStartTimeNanos;
    }

    protected final long requestStartTimeMicros() {
        Preconditions.checkState(this.isRequestStartTimeSet(), "requestStartTime is not set.");
        return this.requestStartTimeMicros;
    }

    public AbstractRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        this.requestStartTimeNanos = requestStartTimeNanos;
        this.requestStartTimeMicros = requestStartTimeMicros;
        this.requestStartTimeSet = true;
        return this;
    }

    protected final HttpMethod method() {
        return this.method;
    }

    protected AbstractRequestContextBuilder method(HttpMethod method) {
        Objects.requireNonNull(method, "method");
        if (this.req != null) {
            Preconditions.checkArgument(method == this.req.method(), "method: %s (expected: same as request.method)", (Object)method);
        } else {
            this.method = method;
        }
        return this;
    }

    protected final String authority() {
        return this.authority;
    }

    protected final RequestTarget requestTarget() {
        return this.reqTarget;
    }

    public AbstractRequestContextBuilder id(RequestId id) {
        this.id = Objects.requireNonNull(id, "id");
        return this;
    }

    protected final RequestId id() {
        if (this.id == null) {
            this.id = RequestId.random();
        }
        return this.id;
    }

    protected final Channel fakeChannel(EventLoop eventLoop) {
        if (this.channel == null) {
            this.channel = new FakeChannel(eventLoop, this.alloc(), this.remoteAddress(), this.localAddress());
        }
        return this.channel;
    }

    protected final boolean timedOut() {
        return this.timedOut;
    }

    public AbstractRequestContextBuilder timedOut(boolean timedOut) {
        this.timedOut = timedOut;
        return this;
    }

    private static final class FakeChannel
    implements Channel {
        private final ChannelId id = DefaultChannelId.newInstance();
        private final EventLoop eventLoop;
        private final ByteBufAllocator alloc;
        private final SocketAddress remoteAddress;
        private final SocketAddress localAddress;

        FakeChannel(EventLoop eventLoop, ByteBufAllocator alloc, SocketAddress remoteAddress, SocketAddress localAddress) {
            this.eventLoop = eventLoop;
            this.alloc = alloc;
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
        }

        @Override
        public ChannelId id() {
            return this.id;
        }

        @Override
        public EventLoop eventLoop() {
            return this.eventLoop;
        }

        @Override
        @Nullable
        public Channel parent() {
            return null;
        }

        @Override
        public ChannelConfig config() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public boolean isRegistered() {
            return false;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public ChannelMetadata metadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SocketAddress localAddress() {
            return this.localAddress;
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public ChannelFuture closeFuture() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public long bytesBeforeUnwritable() {
            return 0L;
        }

        @Override
        public long bytesBeforeWritable() {
            return Long.MAX_VALUE;
        }

        @Override
        public Channel.Unsafe unsafe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPipeline pipeline() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.alloc;
        }

        @Override
        public Channel read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Channel flush() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture disconnect() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture disconnect(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture close(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture deregister() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture deregister(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture write(Object msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture write(Object msg, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise newPromise() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelProgressivePromise newProgressivePromise() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture newSucceededFuture() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelFuture newFailedFuture(Throwable cause) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise voidPromise() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Attribute<T> attr(AttributeKey<T> key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> boolean hasAttr(AttributeKey<T> key) {
            return false;
        }

        @Override
        public int compareTo(Channel o) {
            return this.id().compareTo(o.id());
        }

        public String toString() {
            return "[id: 0x" + this.id.asShortText() + ", L:" + this.localAddress + " - R:" + this.remoteAddress + ']';
        }
    }
}

