/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.CacheControlBuilder;
import karate.com.linecorp.armeria.common.annotation.Nullable;

public abstract class CacheControl {
    private final boolean noCache;
    private final boolean noStore;
    private final boolean noTransform;
    private final long maxAgeSeconds;

    CacheControl(boolean noCache, boolean noStore, boolean noTransform, long maxAgeSeconds) {
        assert (maxAgeSeconds >= -1L) : maxAgeSeconds;
        this.noCache = noCache;
        this.noStore = noStore;
        this.noTransform = noTransform;
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public boolean isEmpty() {
        return !this.noCache && !this.noStore && !this.noTransform && this.maxAgeSeconds < 0L;
    }

    public final boolean noCache() {
        return this.noCache;
    }

    public final boolean noStore() {
        return this.noStore;
    }

    public final boolean noTransform() {
        return this.noTransform;
    }

    public final long maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public abstract CacheControlBuilder toBuilder();

    public abstract String asHeaderValue();

    final StringBuilder newHeaderValueBuffer() {
        StringBuilder buf = new StringBuilder(40);
        if (this.noCache) {
            buf.append(", no-cache");
        }
        if (this.noStore) {
            buf.append(", no-store");
        }
        if (this.noTransform) {
            buf.append(", no-transform");
        }
        if (this.maxAgeSeconds >= 0L) {
            buf.append(", max-age=").append(this.maxAgeSeconds);
        }
        return buf;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheControl)) {
            return false;
        }
        CacheControl that = (CacheControl)o;
        return this.noCache == that.noCache && this.noStore == that.noStore && this.noTransform == that.noTransform && this.maxAgeSeconds == that.maxAgeSeconds;
    }

    public int hashCode() {
        return (((this.noCache ? 1 : 0) * 31 + (this.noStore ? 1 : 0)) * 31 + (this.noTransform ? 1 : 0)) * 31 + (int)(this.maxAgeSeconds ^ this.maxAgeSeconds >>> 32);
    }

    public String toString() {
        String value = this.asHeaderValue();
        return value.isEmpty() ? this.getClass().getSimpleName() + "(<empty>)" : this.getClass().getSimpleName() + '(' + value + ')';
    }
}

