/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.concurrent.Executor;
import karate.com.linecorp.armeria.common.ContextHolder;
import karate.com.linecorp.armeria.common.DefaultContextAwareExecutor;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.internal.common.RequestContextUtil;

public interface ContextAwareExecutor
extends ContextHolder,
Executor {
    public static ContextAwareExecutor of(RequestContext context, Executor executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutor) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutor)executor, ContextAwareExecutor.class);
            return (ContextAwareExecutor)executor;
        }
        return new DefaultContextAwareExecutor(context, executor);
    }

    @Override
    public RequestContext context();

    public Executor withoutContext();
}

