/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import karate.com.linecorp.armeria.common.ContextAwareExecutor;
import karate.com.linecorp.armeria.common.DefaultContextAwareExecutorService;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.internal.common.RequestContextUtil;

public interface ContextAwareExecutorService
extends ContextAwareExecutor,
ExecutorService {
    public static ContextAwareExecutorService of(RequestContext context, ExecutorService executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutorService) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutorService)executor, ContextAwareExecutorService.class);
            return (ContextAwareExecutorService)executor;
        }
        return new DefaultContextAwareExecutorService(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public ExecutorService withoutContext();
}

