/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.ContextAwareProgressiveFutureListener;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.GenericFutureListener;
import karate.io.netty.util.concurrent.GenericProgressiveFutureListener;

final class ContextAwareFutureListener
implements GenericFutureListener {
    private final RequestContext ctx;
    private final GenericFutureListener listener;

    static <T extends Future<?>> GenericFutureListener<T> of(RequestContext ctx, GenericFutureListener listener) {
        if (listener instanceof GenericProgressiveFutureListener) {
            return ContextAwareProgressiveFutureListener.of(ctx, (GenericProgressiveFutureListener)listener);
        }
        return new ContextAwareFutureListener(ctx, listener);
    }

    private ContextAwareFutureListener(RequestContext ctx, GenericFutureListener listener) {
        this.ctx = ctx;
        this.listener = listener;
    }

    public void operationComplete(Future future) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationComplete(future);
        }
    }
}

