/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.util.SafeCloseable;
import karate.io.netty.util.concurrent.Future;
import karate.io.netty.util.concurrent.GenericProgressiveFutureListener;
import karate.io.netty.util.concurrent.ProgressiveFuture;

final class ContextAwareProgressiveFutureListener
implements GenericProgressiveFutureListener {
    private final RequestContext ctx;
    private final GenericProgressiveFutureListener listener;

    static <T extends ProgressiveFuture<?>> GenericProgressiveFutureListener<T> of(RequestContext ctx, GenericProgressiveFutureListener listener) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(listener, "listener");
        return new ContextAwareProgressiveFutureListener(ctx, listener);
    }

    private ContextAwareProgressiveFutureListener(RequestContext ctx, GenericProgressiveFutureListener listener) {
        this.ctx = ctx;
        this.listener = listener;
    }

    public void operationProgressed(ProgressiveFuture future, long progress, long total) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationProgressed(future, progress, total);
        }
    }

    @Override
    public void operationComplete(Future future) throws Exception {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.operationComplete(future);
        }
    }
}

