/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import karate.com.linecorp.armeria.common.ContextAwareExecutorService;
import karate.com.linecorp.armeria.common.DefaultContextAwareScheduledExecutorService;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.internal.common.RequestContextUtil;

public interface ContextAwareScheduledExecutorService
extends ContextAwareExecutorService,
ScheduledExecutorService {
    public static ContextAwareScheduledExecutorService of(RequestContext context, ScheduledExecutorService executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareScheduledExecutorService) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareScheduledExecutorService)executor, ContextAwareScheduledExecutorService.class);
            return (ContextAwareScheduledExecutorService)executor;
        }
        return new DefaultContextAwareScheduledExecutorService(context, executor);
    }

    @Override
    public RequestContext context();

    @Override
    public ScheduledExecutorService withoutContext();
}

