/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.BitSet;
import java.util.Objects;
import karate.com.linecorp.armeria.common.Cookie;
import karate.com.linecorp.armeria.common.CookieUtil;
import karate.com.linecorp.armeria.common.DefaultCookie;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

public final class CookieBuilder {
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieBuilder.validCookieAttributeValueOctets();
    private String name;
    private String value;
    private boolean valueQuoted;
    @Nullable
    private String domain;
    @Nullable
    private String path;
    long maxAge = Long.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private boolean hostOnly;
    @Nullable
    private String sameSite;
    int expiresStart;
    int expiresEnd;

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        bits.set(59, false);
        return bits;
    }

    private static String validateAttributeValue(String value, String valueName) {
        Preconditions.checkArgument(!(value = Objects.requireNonNull(value, valueName).trim()).isEmpty(), "%s is empty.", (Object)valueName);
        int i = CookieUtil.firstInvalidOctet(value, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (i >= 0) {
            throw new IllegalArgumentException(valueName + " contains a prohibited character: " + value.charAt(i));
        }
        return value;
    }

    @Nullable
    private static String trimDomainDot(String domain) {
        if (domain.charAt(domain.length() - 1) == '.') {
            return null;
        }
        if (domain.charAt(0) == '.') {
            return domain.substring(1);
        }
        return domain;
    }

    CookieBuilder(String name, String value) {
        this.name = Objects.requireNonNull(name, "name");
        this.value = Objects.requireNonNull(value, "value");
    }

    CookieBuilder(Cookie cookie) {
        this.name = cookie.name();
        this.value = cookie.value();
        this.valueQuoted = cookie.isValueQuoted();
        this.domain = cookie.domain();
        this.path = cookie.path();
        this.maxAge = cookie.maxAge();
        this.secure = cookie.isSecure();
        this.httpOnly = cookie.isHttpOnly();
        this.hostOnly = cookie.isHostOnly();
        this.sameSite = cookie.sameSite();
    }

    public CookieBuilder name(String name) {
        this.name = Objects.requireNonNull(name, "name");
        return this;
    }

    public CookieBuilder value(String value) {
        this.value = Objects.requireNonNull(value, "value");
        return this;
    }

    public CookieBuilder valueQuoted(boolean valueQuoted) {
        this.valueQuoted = valueQuoted;
        return this;
    }

    public CookieBuilder domain(String domain) {
        this.domain = CookieBuilder.trimDomainDot(CookieBuilder.validateAttributeValue(domain, "domain"));
        return this;
    }

    public CookieBuilder path(String path) {
        this.path = CookieBuilder.validateAttributeValue(path, "path");
        return this;
    }

    public CookieBuilder maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CookieBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public CookieBuilder httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public CookieBuilder hostOnly(boolean hostOnly) {
        this.hostOnly = hostOnly;
        return this;
    }

    public CookieBuilder sameSite(String sameSite) {
        this.sameSite = CookieBuilder.validateAttributeValue(sameSite, "sameSite");
        return this;
    }

    public Cookie build() {
        return new DefaultCookie(this.name, this.value, this.valueQuoted, this.domain, this.path, this.maxAge, this.secure, this.httpOnly, this.hostOnly, this.sameSite);
    }
}

