/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.function.BiConsumer;
import karate.com.linecorp.armeria.common.ContextAwareBiConsumer;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.util.SafeCloseable;

final class DefaultContextAwareBiConsumer<T, U>
implements ContextAwareBiConsumer<T, U> {
    private final RequestContext context;
    private final BiConsumer<T, U> action;

    DefaultContextAwareBiConsumer(RequestContext context, BiConsumer<T, U> action) {
        this.context = Objects.requireNonNull(context, "context");
        this.action = Objects.requireNonNull(action, "action");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public BiConsumer<T, U> withoutContext() {
        return this.action;
    }

    @Override
    public void accept(T t, U u) {
        try (SafeCloseable ignored = this.context.push();){
            this.action.accept(t, u);
        }
    }
}

