/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.function.Consumer;
import karate.com.linecorp.armeria.common.ContextAwareConsumer;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.util.SafeCloseable;

final class DefaultContextAwareConsumer<T>
implements ContextAwareConsumer<T> {
    private final RequestContext context;
    private final Consumer<T> action;

    DefaultContextAwareConsumer(RequestContext context, Consumer<T> action) {
        this.context = Objects.requireNonNull(context, "context");
        this.action = Objects.requireNonNull(action, "action");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Consumer<T> withoutContext() {
        return this.action;
    }

    @Override
    public void accept(T t) {
        try (SafeCloseable ignored = this.context.push();){
            this.action.accept(t);
        }
    }
}

