/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.concurrent.ThreadLocalRandom;
import karate.com.linecorp.armeria.common.RequestId;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;

final class DefaultRequestId
implements RequestId {
    private static final byte[] HEXDIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private final long value;
    @Nullable
    private String longText;
    @Nullable
    private String shortText;

    DefaultRequestId() {
        this(ThreadLocalRandom.current().nextLong());
    }

    DefaultRequestId(long value) {
        this.value = value;
    }

    @Override
    public String text() {
        if (this.longText != null) {
            return this.longText;
        }
        this.longText = this.newLongText();
        return this.longText;
    }

    private String newLongText() {
        String newLongText = (this.value & 0xF000000000000000L) != 0L ? Long.toHexString(this.value) : DefaultRequestId.newTextSlow(this.value, 16);
        return newLongText;
    }

    @Override
    public String shortText() {
        if (this.shortText != null) {
            return this.shortText;
        }
        this.shortText = this.newShortText();
        return this.shortText;
    }

    private String newShortText() {
        int value = (int)(this.value >>> 32);
        String newShortText = (value & 0xF0000000) != 0 ? Integer.toHexString(value) : DefaultRequestId.newTextSlow(value, 8);
        return newShortText;
    }

    private static String newTextSlow(long value, int digits) {
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            byte[] bytes = tempThreadLocals.byteArray(digits);
            for (int i = digits - 1; i >= 0; --i) {
                bytes[i] = HEXDIGITS[(int)value & 0xF];
                value >>>= 4;
            }
            String string = new String(bytes, 0, 0, digits);
            return string;
        }
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultRequestId)) {
            return false;
        }
        DefaultRequestId that = (DefaultRequestId)obj;
        return this.value == that.value;
    }

    public String toString() {
        return this.text();
    }
}

