/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import karate.com.linecorp.armeria.common.AbstractHttpHeadersBuilder;
import karate.com.linecorp.armeria.common.Cookie;
import karate.com.linecorp.armeria.common.Cookies;
import karate.com.linecorp.armeria.common.DefaultResponseHeaders;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeadersBase;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.ResponseHeadersBuilder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;

final class DefaultResponseHeadersBuilder
extends AbstractHttpHeadersBuilder<ResponseHeadersBuilder>
implements ResponseHeadersBuilder {
    private static final String STATUS_HEADER_MISSING = ":status header does not exist.";

    DefaultResponseHeadersBuilder() {
    }

    DefaultResponseHeadersBuilder(DefaultResponseHeaders headers) {
        super(headers);
    }

    @Override
    public ResponseHeaders build() {
        HttpHeadersBase delegate = (HttpHeadersBase)this.delegate();
        if (delegate != null) {
            Preconditions.checkState(delegate.contains(HttpHeaderNames.STATUS), STATUS_HEADER_MISSING);
            return new DefaultResponseHeaders((HttpHeadersBase)this.promoteDelegate());
        }
        HttpHeadersBase parent = (HttpHeadersBase)this.parent();
        if (parent != null) {
            if (parent instanceof ResponseHeaders) {
                return (ResponseHeaders)((Object)parent);
            }
            return this.updateParent(new DefaultResponseHeaders(parent));
        }
        throw new IllegalStateException(STATUS_HEADER_MISSING);
    }

    @Override
    public ResponseHeadersBuilder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        ((HttpHeadersBase)this.setters()).setCookie(ImmutableSet.of(cookie));
        return this;
    }

    @Override
    public Cookies cookies() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        if (getters == null) {
            return Cookies.of();
        }
        return getters.setCookie();
    }

    @Override
    public ResponseHeadersBuilder cookies(Iterable<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookie");
        ((HttpHeadersBase)this.setters()).setCookie(cookies);
        return this;
    }

    @Override
    public ResponseHeadersBuilder cookies(Cookie ... cookies) {
        Objects.requireNonNull(cookies, "cookie");
        return this.cookies(ImmutableSet.copyOf(cookies));
    }

    @Override
    public HttpStatus status() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        Preconditions.checkState(getters != null, STATUS_HEADER_MISSING);
        return getters.status();
    }

    @Override
    public ResponseHeadersBuilder status(int statusCode) {
        ((HttpHeadersBase)this.setters()).status(statusCode);
        return this;
    }

    @Override
    public ResponseHeadersBuilder status(HttpStatus status) {
        ((HttpHeadersBase)this.setters()).status(status);
        return this;
    }
}

