/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.util.Sampler;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.jctools.maps.NonBlockingHashMap;

final class ExceptionSampler
implements Sampler<Class<? extends Throwable>> {
    private final Map<Class<? extends Throwable>, Sampler<Class<? extends Throwable>>> samplers = new NonBlockingHashMap<Class<? extends Throwable>, Sampler<Class<? extends Throwable>>>();
    private final Function<? super Class<? extends Throwable>, ? extends Sampler<Class<? extends Throwable>>> samplerFactory = unused -> Sampler.of(spec);
    private final String spec;

    ExceptionSampler(String spec) {
        this.spec = spec;
    }

    @Override
    public boolean isSampled(Class<? extends Throwable> exceptionType) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        return this.samplers.computeIfAbsent(exceptionType, this.samplerFactory).isSampled(exceptionType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.spec).toString();
    }
}

