/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;

public enum HttpMethod {
    OPTIONS,
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    TRACE,
    CONNECT,
    UNKNOWN;

    private static final Set<HttpMethod> knownMethods;
    private static final Set<HttpMethod> idempotentMethods;

    public static boolean isSupported(String value) {
        Objects.requireNonNull(value, "value");
        switch (value) {
            case "OPTIONS": 
            case "GET": 
            case "HEAD": 
            case "POST": 
            case "PUT": 
            case "PATCH": 
            case "DELETE": 
            case "TRACE": 
            case "CONNECT": {
                return true;
            }
        }
        return false;
    }

    public static Set<HttpMethod> idempotentMethods() {
        return idempotentMethods;
    }

    public static Set<HttpMethod> knownMethods() {
        return knownMethods;
    }

    @Nullable
    public static HttpMethod tryParse(@Nullable String method) {
        if (method == null) {
            return null;
        }
        switch (method) {
            case "OPTIONS": {
                return OPTIONS;
            }
            case "GET": {
                return GET;
            }
            case "HEAD": {
                return HEAD;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "PATCH": {
                return PATCH;
            }
            case "DELETE": {
                return DELETE;
            }
            case "TRACE": {
                return TRACE;
            }
            case "CONNECT": {
                return CONNECT;
            }
        }
        return null;
    }

    static {
        idempotentMethods = Sets.immutableEnumSet((Enum)GET, (Enum[])new HttpMethod[]{HEAD, PUT, DELETE});
        EnumSet<HttpMethod> allMethods = EnumSet.allOf(HttpMethod.class);
        allMethods.remove((Object)UNKNOWN);
        knownMethods = Sets.immutableEnumSet(allMethods);
    }
}

