/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpResponseUtil;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.stream.StreamWriter;

public interface HttpResponseWriter
extends HttpResponse,
StreamWriter<HttpObject> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void close(AggregatedHttpResponse res) {
        boolean transferredContent = false;
        HttpData content = null;
        try {
            HttpHeaders trailers;
            Objects.requireNonNull(res, "res");
            ResponseHeaders headers = res.headers();
            content = res.content();
            if (!this.tryWrite(headers)) {
                return;
            }
            if (headers.status().isContentAlwaysEmpty()) {
                if (!content.isEmpty()) {
                    HttpResponseUtil.httpResponseUtilLogger.debug("Non-empty content found with an empty status: {}, content length: {}", (Object)headers.status(), (Object)content.length());
                }
            } else if (!content.isEmpty()) {
                transferredContent = true;
                if (!this.tryWrite(content)) {
                    return;
                }
            }
            if (!(trailers = res.trailers()).isEmpty()) {
                boolean bl = this.tryWrite(trailers);
            }
        }
        finally {
            this.close();
            if (!transferredContent && content != null) {
                content.close();
            }
        }
    }
}

