/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpStatusClass;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.StringUtil;

public final class HttpStatus
implements Comparable<HttpStatus> {
    private static final HttpStatus[] map = new HttpStatus[1000];
    public static final HttpStatus CONTINUE = HttpStatus.newConstant(100, "Continue");
    public static final HttpStatus SWITCHING_PROTOCOLS = HttpStatus.newConstant(101, "Switching Protocols");
    public static final HttpStatus PROCESSING = HttpStatus.newConstant(102, "Processing");
    public static final HttpStatus OK = HttpStatus.newConstant(200, "OK");
    public static final HttpStatus CREATED = HttpStatus.newConstant(201, "Created");
    public static final HttpStatus ACCEPTED = HttpStatus.newConstant(202, "Accepted");
    public static final HttpStatus NON_AUTHORITATIVE_INFORMATION = HttpStatus.newConstant(203, "Non-Authoritative Information");
    public static final HttpStatus NO_CONTENT = HttpStatus.newConstant(204, "No Content");
    public static final HttpStatus RESET_CONTENT = HttpStatus.newConstant(205, "Reset Content");
    public static final HttpStatus PARTIAL_CONTENT = HttpStatus.newConstant(206, "Partial Content");
    public static final HttpStatus MULTI_STATUS = HttpStatus.newConstant(207, "Multi-Status");
    public static final HttpStatus MULTIPLE_CHOICES = HttpStatus.newConstant(300, "Multiple Choices");
    public static final HttpStatus MOVED_PERMANENTLY = HttpStatus.newConstant(301, "Moved Permanently");
    public static final HttpStatus FOUND = HttpStatus.newConstant(302, "Found");
    public static final HttpStatus SEE_OTHER = HttpStatus.newConstant(303, "See Other");
    public static final HttpStatus NOT_MODIFIED = HttpStatus.newConstant(304, "Not Modified");
    public static final HttpStatus USE_PROXY = HttpStatus.newConstant(305, "Use Proxy");
    public static final HttpStatus TEMPORARY_REDIRECT = HttpStatus.newConstant(307, "Temporary Redirect");
    public static final HttpStatus BAD_REQUEST = HttpStatus.newConstant(400, "Bad Request");
    public static final HttpStatus UNAUTHORIZED = HttpStatus.newConstant(401, "Unauthorized");
    public static final HttpStatus PAYMENT_REQUIRED = HttpStatus.newConstant(402, "Payment Required");
    public static final HttpStatus FORBIDDEN = HttpStatus.newConstant(403, "Forbidden");
    public static final HttpStatus NOT_FOUND = HttpStatus.newConstant(404, "Not Found");
    public static final HttpStatus METHOD_NOT_ALLOWED = HttpStatus.newConstant(405, "Method Not Allowed");
    public static final HttpStatus NOT_ACCEPTABLE = HttpStatus.newConstant(406, "Not Acceptable");
    public static final HttpStatus PROXY_AUTHENTICATION_REQUIRED = HttpStatus.newConstant(407, "Proxy Authentication Required");
    public static final HttpStatus REQUEST_TIMEOUT = HttpStatus.newConstant(408, "Request Timeout");
    public static final HttpStatus CONFLICT = HttpStatus.newConstant(409, "Conflict");
    public static final HttpStatus GONE = HttpStatus.newConstant(410, "Gone");
    public static final HttpStatus LENGTH_REQUIRED = HttpStatus.newConstant(411, "Length Required");
    public static final HttpStatus PRECONDITION_FAILED = HttpStatus.newConstant(412, "Precondition Failed");
    public static final HttpStatus REQUEST_ENTITY_TOO_LARGE = HttpStatus.newConstant(413, "Request Entity Too Large");
    public static final HttpStatus REQUEST_URI_TOO_LONG = HttpStatus.newConstant(414, "Request-URI Too Long");
    public static final HttpStatus UNSUPPORTED_MEDIA_TYPE = HttpStatus.newConstant(415, "Unsupported Media Type");
    public static final HttpStatus REQUESTED_RANGE_NOT_SATISFIABLE = HttpStatus.newConstant(416, "Requested Range Not Satisfiable");
    public static final HttpStatus EXPECTATION_FAILED = HttpStatus.newConstant(417, "Expectation Failed");
    public static final HttpStatus MISDIRECTED_REQUEST = HttpStatus.newConstant(421, "Misdirected Request");
    public static final HttpStatus UNPROCESSABLE_ENTITY = HttpStatus.newConstant(422, "Unprocessable Entity");
    public static final HttpStatus LOCKED = HttpStatus.newConstant(423, "Locked");
    public static final HttpStatus FAILED_DEPENDENCY = HttpStatus.newConstant(424, "Failed Dependency");
    public static final HttpStatus UNORDERED_COLLECTION = HttpStatus.newConstant(425, "Unordered Collection");
    public static final HttpStatus UPGRADE_REQUIRED = HttpStatus.newConstant(426, "Upgrade Required");
    public static final HttpStatus PRECONDITION_REQUIRED = HttpStatus.newConstant(428, "Precondition Required");
    public static final HttpStatus TOO_MANY_REQUESTS = HttpStatus.newConstant(429, "Too Many Requests");
    public static final HttpStatus REQUEST_HEADER_FIELDS_TOO_LARGE = HttpStatus.newConstant(431, "Request Header Fields Too Large");
    public static final HttpStatus CLIENT_CLOSED_REQUEST = HttpStatus.newConstant(499, "Client Closed Request");
    public static final HttpStatus INTERNAL_SERVER_ERROR = HttpStatus.newConstant(500, "Internal Server Error");
    public static final HttpStatus NOT_IMPLEMENTED = HttpStatus.newConstant(501, "Not Implemented");
    public static final HttpStatus BAD_GATEWAY = HttpStatus.newConstant(502, "Bad Gateway");
    public static final HttpStatus SERVICE_UNAVAILABLE = HttpStatus.newConstant(503, "Service Unavailable");
    public static final HttpStatus GATEWAY_TIMEOUT = HttpStatus.newConstant(504, "Gateway Timeout");
    public static final HttpStatus HTTP_VERSION_NOT_SUPPORTED = HttpStatus.newConstant(505, "HTTP Version Not Supported");
    public static final HttpStatus VARIANT_ALSO_NEGOTIATES = HttpStatus.newConstant(506, "Variant Also Negotiates");
    public static final HttpStatus INSUFFICIENT_STORAGE = HttpStatus.newConstant(507, "Insufficient Storage");
    public static final HttpStatus NOT_EXTENDED = HttpStatus.newConstant(510, "Not Extended");
    public static final HttpStatus NETWORK_AUTHENTICATION_REQUIRED = HttpStatus.newConstant(511, "Network Authentication Required");
    public static final HttpStatus UNKNOWN = HttpStatus.newConstant(0, "Unknown reason");
    private final int code;
    private final String codeAsText;
    private final HttpStatusClass codeClass;
    private final String reasonPhrase;
    private final HttpData httpData;
    private final String strVal;

    private static HttpStatus newConstant(int statusCode, String reasonPhrase) {
        HttpStatus status;
        HttpStatus.map[statusCode] = status = new HttpStatus(statusCode, reasonPhrase);
        return status;
    }

    public static HttpStatus valueOf(int statusCode) {
        if (statusCode < 0 || statusCode >= 1000) {
            return new HttpStatus(statusCode);
        }
        return map[statusCode];
    }

    public static HttpStatus valueOf(String statusText) {
        int statusCode;
        block4: {
            Objects.requireNonNull(statusText, "statusText");
            int spaceIdx = statusText.indexOf(32);
            try {
                if (spaceIdx < 0) {
                    statusCode = Integer.parseInt(statusText);
                    break block4;
                }
                if (spaceIdx > 0) {
                    statusCode = Integer.parseInt(statusText.substring(0, spaceIdx));
                    break block4;
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
        return HttpStatus.valueOf(statusCode);
    }

    public static boolean isContentAlwaysEmpty(int statusCode) {
        switch (statusCode) {
            case 204: 
            case 205: 
            case 304: {
                return true;
            }
        }
        return false;
    }

    private HttpStatus(int statusCode) {
        this(statusCode, HttpStatusClass.valueOf(statusCode).defaultReasonPhrase() + " (" + statusCode + ')');
    }

    public HttpStatus(int statusCode, @Nullable String reasonPhrase) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("statusCode: " + statusCode + " (expected: 0+)");
        }
        if (reasonPhrase == null) {
            throw new NullPointerException("reasonPhrase");
        }
        for (int i = 0; i < reasonPhrase.length(); ++i) {
            char c = reasonPhrase.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    throw new IllegalArgumentException("reasonPhrase contains one of the following prohibited characters: \\r\\n: " + reasonPhrase);
                }
            }
        }
        this.code = statusCode;
        this.codeAsText = StringUtil.toString(statusCode);
        this.codeClass = HttpStatusClass.valueOf(statusCode);
        this.reasonPhrase = reasonPhrase;
        this.strVal = new StringBuilder(reasonPhrase.length() + 5).append(statusCode).append(' ').append(reasonPhrase).toString();
        this.httpData = HttpData.ofUtf8(this.strVal);
    }

    public int code() {
        return this.code;
    }

    public String codeAsText() {
        return this.codeAsText;
    }

    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    public HttpStatusClass codeClass() {
        return this.codeClass;
    }

    public HttpData toHttpData() {
        return this.httpData;
    }

    public boolean isContentAlwaysEmpty() {
        return HttpStatus.isContentAlwaysEmpty(this.code);
    }

    public boolean isInformational() {
        return this.codeClass == HttpStatusClass.INFORMATIONAL;
    }

    public boolean isSuccess() {
        return this.codeClass == HttpStatusClass.SUCCESS;
    }

    public boolean isRedirection() {
        return this.codeClass == HttpStatusClass.REDIRECTION;
    }

    public boolean isClientError() {
        return this.codeClass == HttpStatusClass.CLIENT_ERROR;
    }

    public boolean isServerError() {
        return this.codeClass == HttpStatusClass.SERVER_ERROR;
    }

    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public int hashCode() {
        return this.code();
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof HttpStatus)) {
            return false;
        }
        return this.code() == ((HttpStatus)o).code();
    }

    @Override
    public int compareTo(HttpStatus o) {
        return Integer.compare(this.code(), o.code());
    }

    public String toString() {
        return this.strVal;
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            if (map[i] != null) continue;
            HttpStatus.map[i] = new HttpStatus(i);
        }
    }
}

