/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.io.IOException;
import karate.com.fasterxml.jackson.core.JsonParser;
import karate.com.fasterxml.jackson.databind.DeserializationContext;
import karate.com.fasterxml.jackson.databind.JsonNode;
import karate.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;

final class MediaTypeJsonDeserializer
extends StdDeserializer<MediaType> {
    private static final long serialVersionUID = 2081299438299133097L;

    MediaTypeJsonDeserializer() {
        super(MediaType.class);
    }

    @Override
    @Nullable
    public MediaType deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isTextual()) {
            ctx.reportInputMismatch(MediaType.class, "media type must be a string.", new Object[0]);
            return null;
        }
        String textValue = tree.textValue();
        try {
            return MediaType.parse(textValue);
        }
        catch (IllegalArgumentException unused) {
            ctx.reportInputMismatch(MediaType.class, "malformed media type: " + textValue, new Object[0]);
            return null;
        }
    }
}

