/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.DependencyInjector;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OrElseDependencyInjector
implements DependencyInjector {
    private static final Logger logger = LoggerFactory.getLogger(OrElseDependencyInjector.class);
    private final DependencyInjector first;
    private final DependencyInjector second;

    OrElseDependencyInjector(DependencyInjector first, DependencyInjector second) {
        this.first = first;
        this.second = second;
    }

    @Override
    @Nullable
    public <T> T getInstance(Class<T> type) {
        T instance = this.first.getInstance(type);
        if (instance != null) {
            return instance;
        }
        return this.second.getInstance(type);
    }

    @Override
    public void close() {
        OrElseDependencyInjector.close(this.first);
        OrElseDependencyInjector.close(this.second);
    }

    private static void close(DependencyInjector dependencyInjector) {
        try {
            dependencyInjector.close();
        }
        catch (Throwable t) {
            logger.warn("Unexpected exception while closing {}", (Object)dependencyInjector, (Object)t);
        }
    }
}

