/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.function.Consumer;
import karate.com.linecorp.armeria.common.DefaultQueryParams;
import karate.com.linecorp.armeria.common.DefaultQueryParamsBuilder;
import karate.com.linecorp.armeria.common.QueryParamGetters;
import karate.com.linecorp.armeria.common.QueryParamsBuilder;
import karate.com.linecorp.armeria.common.QueryStringDecoder;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;

public interface QueryParams
extends QueryParamGetters {
    public static QueryParamsBuilder builder() {
        return new DefaultQueryParamsBuilder();
    }

    public static QueryParams of() {
        return DefaultQueryParams.EMPTY;
    }

    public static QueryParams of(String name, String value) {
        return QueryParams.builder().add(name, value).build();
    }

    public static QueryParams of(String name, Object value) {
        return QueryParams.builder().addObject(name, value).build();
    }

    public static QueryParams of(String name1, String value1, String name2, String value2) {
        return QueryParams.builder().add(name1, value1).add(name2, value2).build();
    }

    public static QueryParams of(String name1, Object value1, String name2, Object value2) {
        return QueryParams.builder().addObject(name1, value1).addObject(name2, value2).build();
    }

    public static QueryParams of(String name1, String value1, String name2, String value2, String name3, String value3) {
        return QueryParams.builder().add(name1, value1).add(name2, value2).add(name3, value3).build();
    }

    public static QueryParams of(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        return QueryParams.builder().addObject(name1, value1).addObject(name2, value2).addObject(name3, value3).build();
    }

    public static QueryParams of(String name1, String value1, String name2, String value2, String name3, String value3, String name4, String value4) {
        return QueryParams.builder().add(name1, value1).add(name2, value2).add(name3, value3).add(name4, value4).build();
    }

    public static QueryParams of(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) {
        return QueryParams.builder().addObject(name1, value1).addObject(name2, value2).addObject(name3, value3).addObject(name4, value4).build();
    }

    public static QueryParams fromQueryString(@Nullable String queryString) {
        return QueryParams.fromQueryString(queryString, 1024);
    }

    public static QueryParams fromQueryString(@Nullable String queryString, int maxParams) {
        return QueryParams.fromQueryString(queryString, maxParams, false);
    }

    public static QueryParams fromQueryString(@Nullable String queryString, boolean semicolonAsSeparator) {
        return QueryParams.fromQueryString(queryString, 1024, semicolonAsSeparator);
    }

    public static QueryParams fromQueryString(@Nullable String queryString, int maxParams, boolean semicolonAsSeparator) {
        if (Strings.isNullOrEmpty(queryString)) {
            return QueryParams.of();
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            QueryParams queryParams = QueryStringDecoder.decodeParams(tempThreadLocals, queryString, maxParams, semicolonAsSeparator);
            return queryParams;
        }
    }

    public QueryParamsBuilder toBuilder();

    default public QueryParams withMutations(Consumer<QueryParamsBuilder> mutator) {
        Objects.requireNonNull(mutator, "mutator");
        QueryParamsBuilder builder = this.toBuilder();
        mutator.accept(builder);
        return builder.build();
    }
}

