/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import karate.com.linecorp.armeria.common.CompletableRpcResponse;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;

public interface RpcResponse
extends Response,
CompletionStage<Object>,
Future<Object> {
    public static RpcResponse of(@Nullable Object value) {
        CompletableRpcResponse future = new CompletableRpcResponse();
        future.complete(value);
        return future;
    }

    public static RpcResponse ofFailure(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        CompletableRpcResponse future = new CompletableRpcResponse();
        future.completeExceptionally(cause);
        return future;
    }

    public static RpcResponse from(CompletionStage<?> stage) {
        Objects.requireNonNull(stage, "stage");
        CompletableRpcResponse res = new CompletableRpcResponse();
        stage.handle((value, cause) -> {
            if (cause != null) {
                res.completeExceptionally(Exceptions.peel(cause));
            } else if (value instanceof RpcResponse) {
                ((RpcResponse)value).handle((rpcResponseResult, rpcResponseCause) -> {
                    if (rpcResponseCause != null) {
                        res.completeExceptionally(Exceptions.peel(rpcResponseCause));
                    } else {
                        res.complete(rpcResponseResult);
                    }
                    return null;
                });
            } else {
                res.complete(value);
            }
            return null;
        });
        return res;
    }

    public Object join();

    public Object getNow(Object var1);

    @Nullable
    public Throwable cause();

    public boolean isCompletedExceptionally();

    @Override
    default public CompletableFuture<?> whenComplete() {
        return this.toCompletableFuture();
    }
}

