/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.time.Duration;
import karate.com.linecorp.armeria.common.CacheControlBuilder;
import karate.com.linecorp.armeria.common.ServerCacheControl;
import karate.com.linecorp.armeria.common.annotation.Nullable;

public final class ServerCacheControlBuilder
extends CacheControlBuilder {
    private boolean cachePublic;
    private boolean cachePrivate;
    private boolean immutable;
    private boolean mustRevalidate;
    private boolean proxyRevalidate;
    private long sMaxAgeSeconds = -1L;

    ServerCacheControlBuilder() {
    }

    ServerCacheControlBuilder(ServerCacheControl c) {
        super(c);
        this.cachePublic = c.cachePublic();
        this.cachePrivate = c.cachePrivate();
        this.immutable = c.immutable();
        this.mustRevalidate = c.mustRevalidate();
        this.proxyRevalidate = c.proxyRevalidate();
        this.sMaxAgeSeconds = c.sMaxAgeSeconds();
    }

    public ServerCacheControlBuilder cachePublic() {
        return this.cachePublic(true);
    }

    public ServerCacheControlBuilder cachePublic(boolean cachePublic) {
        this.cachePublic = cachePublic;
        return this;
    }

    public ServerCacheControlBuilder cachePrivate() {
        return this.cachePrivate(true);
    }

    public ServerCacheControlBuilder cachePrivate(boolean cachePrivate) {
        this.cachePrivate = cachePrivate;
        return this;
    }

    public ServerCacheControlBuilder immutable() {
        return this.immutable(true);
    }

    public ServerCacheControlBuilder immutable(boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    public ServerCacheControlBuilder mustRevalidate() {
        return this.mustRevalidate(true);
    }

    public ServerCacheControlBuilder mustRevalidate(boolean mustRevalidate) {
        this.mustRevalidate = mustRevalidate;
        return this;
    }

    public ServerCacheControlBuilder proxyRevalidate() {
        return this.proxyRevalidate(true);
    }

    public ServerCacheControlBuilder proxyRevalidate(boolean proxyRevalidate) {
        this.proxyRevalidate = proxyRevalidate;
        return this;
    }

    public ServerCacheControlBuilder sMaxAge(@Nullable Duration sMaxAge) {
        this.sMaxAgeSeconds = ServerCacheControlBuilder.validateDuration(sMaxAge, "sMaxAge");
        return this;
    }

    public ServerCacheControlBuilder sMaxAgeSeconds(long sMaxAgeSeconds) {
        this.sMaxAgeSeconds = ServerCacheControlBuilder.validateSeconds(sMaxAgeSeconds, "sMaxAgeSeconds");
        return this;
    }

    @Override
    public ServerCacheControl build() {
        return (ServerCacheControl)super.build();
    }

    @Override
    ServerCacheControl build(boolean noCache, boolean noStore, boolean noTransform, long maxAgeSeconds) {
        boolean cachePublic = this.cachePrivate ? false : this.cachePublic;
        return new ServerCacheControl(noCache, noStore, noTransform, maxAgeSeconds, cachePublic, this.cachePrivate, this.immutable, this.mustRevalidate, this.proxyRevalidate, this.sMaxAgeSeconds);
    }

    @Override
    public ServerCacheControlBuilder noCache() {
        return (ServerCacheControlBuilder)super.noCache();
    }

    @Override
    public ServerCacheControlBuilder noCache(boolean noCache) {
        return (ServerCacheControlBuilder)super.noCache(noCache);
    }

    @Override
    public ServerCacheControlBuilder noStore() {
        return (ServerCacheControlBuilder)super.noStore();
    }

    @Override
    public ServerCacheControlBuilder noStore(boolean noStore) {
        return (ServerCacheControlBuilder)super.noStore(noStore);
    }

    @Override
    public ServerCacheControlBuilder noTransform() {
        return (ServerCacheControlBuilder)super.noTransform();
    }

    @Override
    public ServerCacheControlBuilder noTransform(boolean noTransform) {
        return (ServerCacheControlBuilder)super.noTransform(noTransform);
    }

    @Override
    public ServerCacheControlBuilder maxAge(@Nullable Duration maxAge) {
        return (ServerCacheControlBuilder)super.maxAge(maxAge);
    }

    @Override
    public ServerCacheControlBuilder maxAgeSeconds(long maxAgeSeconds) {
        return (ServerCacheControlBuilder)super.maxAgeSeconds(maxAgeSeconds);
    }
}

