/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.CookieBuilder;
import karate.com.linecorp.armeria.common.CookieUtil;
import karate.com.linecorp.armeria.common.Cookies;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerCookieDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ServerCookieDecoder.class);
    private static final String RFC2965_VERSION = "$Version";
    private static final String RFC2965_PATH = "$Path";
    private static final String RFC2965_DOMAIN = "$Domain";
    private static final String RFC2965_PORT = "$Port";

    static Cookies decode(boolean strict, String header) {
        int headerLen = header.length();
        ImmutableSet.Builder cookies = ImmutableSet.builder();
        int i = 0;
        boolean rfc2965Style = false;
        if (header.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
            i = header.indexOf(59) + 1;
            rfc2965Style = true;
        }
        while (i != headerLen) {
            CookieBuilder builder;
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block8: {
                char c = header.charAt(i);
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (curChar != '=') continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            i = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = i;
                        }
                    }
                    break block8;
                } while (++i != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (rfc2965Style && (header.regionMatches(nameBegin, RFC2965_PATH, 0, RFC2965_PATH.length()) || header.regionMatches(nameBegin, RFC2965_DOMAIN, 0, RFC2965_DOMAIN.length()) || header.regionMatches(nameBegin, RFC2965_PORT, 0, RFC2965_PORT.length())) || (builder = CookieUtil.initCookie(logger, strict, header, nameBegin, nameEnd, valueBegin, valueEnd)) == null) continue;
            cookies.add(builder.build());
        }
        return Cookies.of(cookies.build());
    }

    private ServerCookieDecoder() {
    }
}

