/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;

public enum SessionProtocol {
    HTTPS("https", true, false, 443),
    HTTP("http", false, false, 80),
    H1("h1", true, false, 443),
    H1C("h1c", false, false, 80),
    H2("h2", true, true, 443),
    H2C("h2c", false, true, 80),
    PROXY("proxy", false, false, 0);

    private static final Set<SessionProtocol> HTTP_VALUES;
    private static final Set<SessionProtocol> HTTPS_VALUES;
    private static final Set<SessionProtocol> HTTP_AND_HTTPS_VALUES;
    private static final Map<String, SessionProtocol> uriTextToProtocols;
    private final String uriText;
    private final boolean useTls;
    private final boolean isMultiplex;
    private final int defaultPort;

    public static SessionProtocol of(String uriText) {
        SessionProtocol value = uriTextToProtocols.get(uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText")));
        Preconditions.checkArgument(value != null, "unknown session protocol: %s", (Object)uriText);
        return value;
    }

    @Nullable
    public static SessionProtocol find(String uriText) {
        uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText"));
        return uriTextToProtocols.get(uriText);
    }

    public static Set<SessionProtocol> httpValues() {
        return HTTP_VALUES;
    }

    public static Set<SessionProtocol> httpsValues() {
        return HTTPS_VALUES;
    }

    @UnstableApi
    public static Set<SessionProtocol> httpAndHttpsValues() {
        return HTTP_AND_HTTPS_VALUES;
    }

    private SessionProtocol(String uriText, boolean useTls, boolean isMultiplex, int defaultPort) {
        this.useTls = useTls;
        this.uriText = uriText;
        this.isMultiplex = isMultiplex;
        this.defaultPort = defaultPort;
    }

    public boolean isHttp() {
        return HTTP_VALUES.contains((Object)this);
    }

    public boolean isHttps() {
        return HTTPS_VALUES.contains((Object)this);
    }

    public boolean isExplicitHttp1() {
        return this == H1 || this == H1C;
    }

    public boolean isExplicitHttp2() {
        return this == H2 || this == H2C;
    }

    public boolean isTls() {
        return this.useTls;
    }

    public String uriText() {
        return this.uriText;
    }

    public boolean isMultiplex() {
        return this.isMultiplex;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public String toString() {
        return this.uriText;
    }

    static {
        HTTP_VALUES = Sets.immutableEnumSet((Enum)HTTP, (Enum[])new SessionProtocol[]{H1C, H2C});
        HTTPS_VALUES = Sets.immutableEnumSet((Enum)HTTPS, (Enum[])new SessionProtocol[]{H1, H2});
        HTTP_AND_HTTPS_VALUES = Sets.immutableEnumSet((Enum)HTTPS, (Enum[])new SessionProtocol[]{HTTP, H1, H1C, H2, H2C});
        ImmutableMap.Builder<String, SessionProtocol> builder = ImmutableMap.builder();
        for (SessionProtocol e : SessionProtocol.values()) {
            builder.put(e.uriText(), e);
        }
        uriTextToProtocols = builder.build();
    }
}

