/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.RpcResponse;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.logging.RequestLog;

@FunctionalInterface
@UnstableApi
public interface SuccessFunction {
    public static SuccessFunction never() {
        return (ctx, log) -> false;
    }

    public static SuccessFunction always() {
        return (ctx, log) -> true;
    }

    public static SuccessFunction ofDefault() {
        return (ctx, log) -> {
            if (log.responseCause() != null) {
                return false;
            }
            int statusCode = log.responseHeaders().status().code();
            if (statusCode < 100 || statusCode >= 400) {
                return false;
            }
            Object responseContent = log.responseContent();
            if (responseContent instanceof RpcResponse) {
                return !((RpcResponse)responseContent).isCompletedExceptionally();
            }
            return true;
        };
    }

    public boolean isSuccess(RequestContext var1, RequestLog var2);
}

