/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common;

import java.util.Objects;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.RequestContextStorage;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.RequestContextUtil;
import karate.io.netty.util.concurrent.FastThreadLocal;
import karate.io.netty.util.internal.InternalThreadLocalMap;

enum ThreadLocalRequestContextStorage implements RequestContextStorage
{
    INSTANCE;

    private static final FastThreadLocal<RequestContext> context;

    @Override
    @Nullable
    public <T extends RequestContext> T push(RequestContext toPush) {
        Objects.requireNonNull(toPush, "toPush");
        InternalThreadLocalMap map = InternalThreadLocalMap.get();
        RequestContext oldCtx = context.get(map);
        context.set(map, toPush);
        return (T)oldCtx;
    }

    @Override
    public void pop(RequestContext current, @Nullable RequestContext toRestore) {
        Objects.requireNonNull(current, "current");
        InternalThreadLocalMap map = InternalThreadLocalMap.get();
        RequestContext contextInThreadLocal = context.get(map);
        if (contextInThreadLocal == null || current.unwrapAll() != contextInThreadLocal.unwrapAll()) {
            throw RequestContextUtil.newIllegalContextPoppingException(current, contextInThreadLocal);
        }
        context.set(map, toRestore);
    }

    @Override
    @Nullable
    public <T extends RequestContext> T currentOrNull() {
        return (T)context.get();
    }

    static {
        context = new FastThreadLocal();
    }
}

