/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.auth;

import java.util.Map;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.auth.OAuth1aToken;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;

public final class OAuth1aTokenBuilder {
    private static final String DEFAULT_OAUTH_VERSION = "1.0";
    @Nullable
    private String consumerKey;
    @Nullable
    private String token;
    @Nullable
    private String signatureMethod;
    @Nullable
    private String signature;
    @Nullable
    private String timestamp;
    @Nullable
    private String nonce;
    @Nullable
    private String realm;
    private String version = "1.0";
    private final ImmutableMap.Builder<String, String> additionalsBuilder = ImmutableMap.builder();

    OAuth1aTokenBuilder() {
    }

    public OAuth1aTokenBuilder realm(String realm) {
        this.realm = Objects.requireNonNull(realm, "realm");
        return this;
    }

    public OAuth1aTokenBuilder consumerKey(String consumerKey) {
        this.consumerKey = Objects.requireNonNull(consumerKey, "consumerKey");
        return this;
    }

    public OAuth1aTokenBuilder token(String token) {
        this.token = Objects.requireNonNull(token, "token");
        return this;
    }

    public OAuth1aTokenBuilder signatureMethod(String signatureMethod) {
        this.signatureMethod = Objects.requireNonNull(signatureMethod, "signatureMethod");
        return this;
    }

    public OAuth1aTokenBuilder signature(String signature) {
        this.signature = Objects.requireNonNull(signature, "signature");
        return this;
    }

    public OAuth1aTokenBuilder timestamp(String timestamp) {
        try {
            Long.parseLong(Objects.requireNonNull(timestamp, "timestamp"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("timestamp: " + timestamp + " (expected: a string containing a long representation)");
        }
        this.timestamp = timestamp;
        return this;
    }

    public OAuth1aTokenBuilder nonce(String nonce) {
        this.nonce = Objects.requireNonNull(nonce, "nonce");
        return this;
    }

    public OAuth1aTokenBuilder version(String version) {
        this.version = Objects.requireNonNull(version, "version");
        return this;
    }

    public OAuth1aTokenBuilder put(String key, String value) {
        String lowerCased;
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        switch (lowerCased = Ascii.toLowerCase(key)) {
            case "realm": {
                this.realm(value);
                break;
            }
            case "oauth_consumer_key": {
                this.consumerKey(value);
                break;
            }
            case "oauth_token": {
                this.token(value);
                break;
            }
            case "oauth_signature_method": {
                this.signatureMethod(value);
                break;
            }
            case "oauth_signature": {
                this.signature(value);
                break;
            }
            case "oauth_timestamp": {
                this.timestamp(value);
                break;
            }
            case "oauth_nonce": {
                this.nonce(value);
                break;
            }
            case "version": {
                this.version(value);
                break;
            }
            default: {
                this.additionalsBuilder.put(key, value);
            }
        }
        return this;
    }

    public OAuth1aTokenBuilder putAll(Map<String, String> params) {
        Objects.requireNonNull(params, "params");
        for (Map.Entry<String, String> param : params.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (Strings.isNullOrEmpty(key) || Strings.isNullOrEmpty(value)) continue;
            this.put(key, value);
        }
        return this;
    }

    public OAuth1aToken build() {
        Preconditions.checkState(this.consumerKey != null, "consumerKey is not set.");
        Preconditions.checkState(this.token != null, "token is not set.");
        Preconditions.checkState(this.signatureMethod != null, "signatureMethod is not set.");
        Preconditions.checkState(this.signature != null, "signature is not set.");
        Preconditions.checkState(this.timestamp != null, "timestamp is not set.");
        Preconditions.checkState(this.nonce != null, "nonce is not set.");
        return new OAuth1aToken(this.consumerKey, this.token, this.signatureMethod, this.signature, this.timestamp, this.nonce, this.version, this.additionalsBuilder.build(), this.realm);
    }
}

