/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.encoding;

import java.util.List;
import karate.com.linecorp.armeria.common.encoding.BrotliStreamDecoder;
import karate.com.linecorp.armeria.common.encoding.SnappyStreamDecoder;
import karate.com.linecorp.armeria.common.encoding.StreamDecoder;
import karate.com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import karate.com.linecorp.armeria.common.encoding.ZlibStreamDecoder;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.buffer.ByteBufAllocator;
import karate.io.netty.handler.codec.compression.Brotli;
import karate.io.netty.handler.codec.compression.BrotliDecoder;
import karate.io.netty.handler.codec.compression.SnappyFrameDecoder;
import karate.io.netty.handler.codec.compression.ZlibWrapper;

enum StreamDecoderFactories implements StreamDecoderFactory
{
    BROTLI{

        @Override
        public String encodingHeaderValue() {
            return "br";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new BrotliStreamDecoder(new BrotliDecoder(), alloc, maxLength);
        }
    }
    ,
    GZIP{

        @Override
        public String encodingHeaderValue() {
            return "gzip";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new ZlibStreamDecoder(ZlibWrapper.GZIP, alloc, maxLength);
        }
    }
    ,
    DEFLATE{

        @Override
        public String encodingHeaderValue() {
            return "deflate";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new ZlibStreamDecoder(ZlibWrapper.ZLIB, alloc, maxLength);
        }
    }
    ,
    SNAPPY{

        @Override
        public String encodingHeaderValue() {
            return "x-snappy-framed";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new SnappyStreamDecoder(new SnappyFrameDecoder(), alloc, maxLength);
        }
    };

    static final List<StreamDecoderFactory> ALL;

    static {
        ALL = Brotli.isAvailable() ? ImmutableList.copyOf(StreamDecoderFactories.values()) : ImmutableList.of(GZIP, DEFLATE, SNAPPY);
    }
}

