/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.logging.HeaderMaskingFunction;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.io.netty.util.AsciiString;

abstract class AbstractHeadersSanitizerBuilder<SELF extends AbstractHeadersSanitizerBuilder<SELF, T>, T> {
    private static final Set<AsciiString> DEFAULT_SENSITIVE_HEADERS = ImmutableSet.of(HttpHeaderNames.AUTHORIZATION, HttpHeaderNames.COOKIE, HttpHeaderNames.SET_COOKIE, HttpHeaderNames.PROXY_AUTHORIZATION);
    @Nullable
    private Set<AsciiString> sensitiveHeaders;
    private HeaderMaskingFunction maskingFunction = HeaderMaskingFunction.of();

    AbstractHeadersSanitizerBuilder() {
    }

    final SELF self() {
        return (SELF)this;
    }

    public SELF sensitiveHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.sensitiveHeaders(ImmutableSet.copyOf(headers));
    }

    public SELF sensitiveHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        if (this.sensitiveHeaders == null) {
            this.sensitiveHeaders = new HashSet<AsciiString>();
        }
        headers.forEach(header -> this.sensitiveHeaders.add(AsciiString.of(header).toLowerCase()));
        return this.self();
    }

    final Set<AsciiString> sensitiveHeaders() {
        if (this.sensitiveHeaders != null) {
            return ImmutableSet.copyOf(this.sensitiveHeaders);
        }
        return DEFAULT_SENSITIVE_HEADERS;
    }

    public SELF maskingFunction(HeaderMaskingFunction maskingFunction) {
        this.maskingFunction = Objects.requireNonNull(maskingFunction, "maskingFunction");
        return this.self();
    }

    final HeaderMaskingFunction maskingFunction() {
        return this.maskingFunction;
    }
}

