/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.nio.charset.Charset;
import java.util.List;
import java.util.function.BiFunction;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.logging.ContentPreviewer;
import karate.com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import karate.com.linecorp.armeria.common.logging.PreviewSpec;
import karate.com.linecorp.armeria.common.logging.ProducerBasedContentPreviewer;
import karate.com.linecorp.armeria.common.logging.TextContentPreviewer;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.io.netty.buffer.ByteBuf;

final class DefaultContentPreviewFactory
implements ContentPreviewerFactory {
    private static final List<String> textSubTypes = ImmutableList.of("json", "xml");
    private static final List<String> textSubTypeSuffixes = ImmutableList.of("+json", "+xml");
    private final int maxLength;
    private final List<PreviewSpec> previewSpecs;
    private final Charset defaultCharset;

    DefaultContentPreviewFactory(List<PreviewSpec> previewSpecs, int maxLength, Charset defaultCharset) {
        this.maxLength = maxLength;
        this.previewSpecs = previewSpecs;
        this.defaultCharset = defaultCharset;
    }

    @Override
    public ContentPreviewer requestContentPreviewer(RequestContext ctx, RequestHeaders headers) {
        return this.contentPreviewer(ctx, headers);
    }

    @Override
    public ContentPreviewer responseContentPreviewer(RequestContext ctx, ResponseHeaders resHeaders) {
        return this.contentPreviewer(ctx, resHeaders);
    }

    private ContentPreviewer contentPreviewer(RequestContext ctx, HttpHeaders headers) {
        block11: {
            block12: {
                for (PreviewSpec previewSpec : this.previewSpecs) {
                    if (!previewSpec.predicate().test(ctx, headers)) continue;
                    switch (previewSpec.mode()) {
                        case TEXT: {
                            Charset charset = this.charset(headers);
                            return new TextContentPreviewer(this.maxLength, charset);
                        }
                        case BINARY: {
                            BiFunction<? super HttpHeaders, ? super ByteBuf, String> producer = previewSpec.producer();
                            assert (producer != null);
                            return new ProducerBasedContentPreviewer(this.maxLength, headers, producer);
                        }
                        case DISABLED: {
                            return ContentPreviewer.disabled();
                        }
                    }
                }
                MediaType contentType = headers.contentType();
                if (contentType == null) break block11;
                Charset charset = contentType.charset();
                if (charset != null) {
                    return new TextContentPreviewer(this.maxLength, charset);
                }
                if ("text".equals(contentType.type()) || textSubTypes.contains(contentType.subtype())) break block12;
                if (!textSubTypeSuffixes.stream().anyMatch(contentType.subtype()::endsWith) && !contentType.is(MediaType.FORM_DATA)) break block11;
            }
            return new TextContentPreviewer(this.maxLength, this.defaultCharset);
        }
        return ContentPreviewer.disabled();
    }

    private Charset charset(HttpHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType != null) {
            return contentType.charset(this.defaultCharset);
        }
        return this.defaultCharset;
    }
}

