/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.common.logging;

import java.util.Objects;
import java.util.function.BiFunction;
import karate.com.fasterxml.jackson.databind.JsonNode;
import karate.com.fasterxml.jackson.databind.ObjectMapper;
import karate.com.linecorp.armeria.common.RequestContext;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.logging.AbstractLogFormatterBuilder;
import karate.com.linecorp.armeria.common.logging.HeadersSanitizer;
import karate.com.linecorp.armeria.common.logging.JsonLogFormatter;
import karate.com.linecorp.armeria.common.logging.LogFormatter;
import karate.com.linecorp.armeria.internal.common.JacksonUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;

@UnstableApi
public final class JsonLogFormatterBuilder
extends AbstractLogFormatterBuilder<JsonLogFormatterBuilder, JsonNode> {
    @Nullable
    private ObjectMapper objectMapper;

    JsonLogFormatterBuilder() {
    }

    public JsonLogFormatterBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        return this;
    }

    public LogFormatter build() {
        ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : JacksonUtil.newDefaultObjectMapper();
        HeadersSanitizer<JsonNode> defaultHeadersSanitizer = JsonLogFormatterBuilder.defaultHeadersSanitizer(objectMapper);
        BiFunction defaultContentSanitizer = JsonLogFormatterBuilder.defaultSanitizer(objectMapper);
        return new JsonLogFormatter(MoreObjects.firstNonNull(this.requestHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.responseHeadersSanitizer(), HeadersSanitizer.ofJson()), MoreObjects.firstNonNull(this.requestTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.responseTrailersSanitizer(), defaultHeadersSanitizer), MoreObjects.firstNonNull(this.requestContentSanitizer(), defaultContentSanitizer), MoreObjects.firstNonNull(this.responseContentSanitizer(), defaultContentSanitizer), objectMapper);
    }

    private static <T> BiFunction<? super RequestContext, T, JsonNode> defaultSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }

    private static HeadersSanitizer<JsonNode> defaultHeadersSanitizer(ObjectMapper objectMapper) {
        return (requestContext, obj) -> objectMapper.valueToTree(obj);
    }
}

